/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.Objects;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractQueryParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.type.BindableType;

public class QueryParameterNamedImpl<T>
extends AbstractQueryParameter<T> {
    private final String name;

    public static <T> QueryParameterNamedImpl<T> fromSqm(SqmParameter<T> parameter) {
        assert (parameter.getName() != null);
        assert (parameter.getPosition() == null);
        return new QueryParameterNamedImpl<T>(parameter.getName(), parameter.allowMultiValuedBinding(), parameter.getAnticipatedType());
    }

    public static <T> QueryParameterNamedImpl<T> fromNativeQuery(String name) {
        return new QueryParameterNamedImpl<T>(name, true, null);
    }

    private QueryParameterNamedImpl(String name, boolean allowMultiValuedBinding, BindableType<T> anticipatedType) {
        super(allowMultiValuedBinding, anticipatedType);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NamedQueryMemento.ParameterMemento toMemento() {
        return session -> new QueryParameterNamedImpl(this.getName(), this.allowsMultiValuedBinding(), this.getHibernateType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryParameterNamedImpl)) {
            return false;
        }
        QueryParameterNamedImpl that = (QueryParameterNamedImpl)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

