/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.dynamic;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicFetchBuilderStandard
implements DynamicFetchBuilder,
NativeQuery.ReturnProperty {
    private final Fetchable fetchable;
    private final List<String> columnNames;

    public DynamicFetchBuilderStandard(Fetchable fetchable) {
        this(fetchable, new ArrayList<String>());
    }

    private DynamicFetchBuilderStandard(Fetchable fetchable, List<String> columnNames) {
        this.fetchable = fetchable;
        this.columnNames = columnNames;
    }

    @Override
    public DynamicFetchBuilderStandard cacheKeyInstance() {
        return new DynamicFetchBuilderStandard(this.fetchable, List.copyOf(this.columnNames));
    }

    public DynamicFetchBuilderStandard cacheKeyInstance(DynamicFetchBuilderContainer container) {
        return new DynamicFetchBuilderStandard(this.fetchable, List.copyOf(this.columnNames));
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup ownerTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        BasicValuedModelPart basicPart = this.fetchable.asBasicValuedModelPart();
        if (basicPart != null) {
            this.fetchable.forEachSelectable(this.getSelectableConsumer(fetchPath, jdbcResultsMetadata, domainResultCreationState, creationStateImpl, ownerTableGroup, sqlExpressionResolver, basicPart));
            return parent.generateFetchableFetch(this.fetchable, fetchPath, FetchTiming.IMMEDIATE, true, null, creationStateImpl);
        }
        Fetchable fetchable = this.fetchable;
        if (fetchable instanceof EmbeddableValuedFetchable) {
            EmbeddableValuedFetchable embeddableValuedFetchable = (EmbeddableValuedFetchable)fetchable;
            this.fetchable.forEachSelectable(this.getSelectableConsumer(fetchPath, jdbcResultsMetadata, domainResultCreationState, creationStateImpl, ownerTableGroup, sqlExpressionResolver, embeddableValuedFetchable));
            return parent.generateFetchableFetch(this.fetchable, fetchPath, FetchTiming.IMMEDIATE, false, null, creationStateImpl);
        }
        fetchable = this.fetchable;
        if (fetchable instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)fetchable;
            toOneAttributeMapping.getForeignKeyDescriptor().getPart(toOneAttributeMapping.getSideNature()).forEachSelectable(this.getSelectableConsumer(fetchPath, jdbcResultsMetadata, domainResultCreationState, creationStateImpl, ownerTableGroup, sqlExpressionResolver, toOneAttributeMapping.getForeignKeyDescriptor()));
            return parent.generateFetchableFetch(this.fetchable, fetchPath, this.fetchable.getMappedFetchOptions().getTiming(), false, null, creationStateImpl);
        }
        fetchable = this.fetchable;
        if (fetchable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
            pluralAttributeMapping.getKeyDescriptor().visitTargetSelectables(this.getSelectableConsumer(fetchPath, jdbcResultsMetadata, domainResultCreationState, creationStateImpl, ownerTableGroup, sqlExpressionResolver, pluralAttributeMapping.getKeyDescriptor()));
            return parent.generateFetchableFetch(this.fetchable, fetchPath, this.fetchable.getMappedFetchOptions().getTiming(), false, null, creationStateImpl);
        }
        throw new AssertionFailure("Unexpected attribute mapping");
    }

    private SelectableConsumer getSelectableConsumer(NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState, DomainResultCreationStateImpl creationStateImpl, TableGroup ownerTableGroup, SqlExpressionResolver sqlExpressionResolver, ValuedModelPart valuedModelPart) {
        return (selectionIndex, selectableMapping) -> {
            TableReference tableReference = ownerTableGroup.resolveTableReference(fetchPath, valuedModelPart, selectableMapping.getContainingTableExpression());
            String columnAlias = this.columnNames.get(selectionIndex);
            sqlExpressionResolver.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableReference, selectableMapping, columnAlias), selectableMapping.getJdbcMapping().getJdbcJavaType(), null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getTypeConfiguration());
        };
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        this.columnNames.add(columnAlias);
        return this;
    }

    @Override
    public List<String> getColumnAliases() {
        return this.columnNames;
    }

    public int hashCode() {
        int result = this.fetchable.hashCode();
        result = 31 * result + this.columnNames.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicFetchBuilderStandard that = (DynamicFetchBuilderStandard)o;
        return this.fetchable.equals(that.fetchable) && this.columnNames.equals(that.columnNames);
    }
}

