/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ManyToManyCollectionPart;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.complete.CompleteFetchBuilder;
import org.hibernate.query.results.internal.dynamic.AbstractFetchBuilderContainer;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntity;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseConstant;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicResultBuilderEntityStandard
extends AbstractFetchBuilderContainer<DynamicResultBuilderEntityStandard>
implements DynamicResultBuilderEntity,
NativeQuery.RootReturn {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityMapping;
    private final String tableAlias;
    private LockMode lockMode;
    private List<String> idColumnNames;
    private String discriminatorColumnName;

    public DynamicResultBuilderEntityStandard(EntityMappingType entityMapping, String tableAlias) {
        this(entityMapping, tableAlias, new NavigablePath(entityMapping.getEntityName()));
    }

    public DynamicResultBuilderEntityStandard(EntityMappingType entityMapping, String tableAlias, NavigablePath navigablePath) {
        this.navigablePath = navigablePath;
        this.entityMapping = entityMapping;
        this.tableAlias = tableAlias;
    }

    private DynamicResultBuilderEntityStandard(DynamicResultBuilderEntityStandard original) {
        super(original);
        this.navigablePath = original.navigablePath;
        this.entityMapping = original.entityMapping;
        this.tableAlias = original.tableAlias;
        this.lockMode = original.lockMode;
        this.idColumnNames = original.idColumnNames == null ? null : List.copyOf(original.idColumnNames);
        this.discriminatorColumnName = original.discriminatorColumnName;
    }

    @Override
    public Class<?> getJavaType() {
        return this.entityMapping.getJavaType().getJavaTypeClass();
    }

    @Override
    public EntityMappingType getEntityMapping() {
        return this.entityMapping;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public NativeQuery.RootReturn addIdColumnAliases(String ... aliases) {
        if (this.idColumnNames == null) {
            this.idColumnNames = new ArrayList<String>(aliases.length);
        }
        Collections.addAll(this.idColumnNames, aliases);
        return this;
    }

    @Override
    public String getDiscriminatorAlias() {
        return this.discriminatorColumnName;
    }

    @Override
    protected String getPropertyBase() {
        return this.entityMapping.getEntityName();
    }

    @Override
    public DynamicResultBuilderEntityStandard cacheKeyInstance() {
        return new DynamicResultBuilderEntityStandard(this);
    }

    @Override
    public EntityResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        return this.buildResultOrFetch(tableGroup -> (EntityResult)this.entityMapping.createDomainResult(this.navigablePath, (TableGroup)tableGroup, this.tableAlias, domainResultCreationState), null, jdbcResultsMetadata, domainResultCreationState);
    }

    public Fetch buildFetch(FetchParent parent, Fetchable fetchable, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        return this.buildResultOrFetch(tableGroup -> parent.generateFetchableFetch(fetchable, parent.resolveNavigablePath(fetchable), FetchTiming.IMMEDIATE, true, null, domainResultCreationState), fetchable, jdbcResultsMetadata, domainResultCreationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T buildResultOrFetch(Function<TableGroup, T> resultOrFetchBuilder, Fetchable fetchable, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        NavigablePath elementNavigablePath;
        TableGroup collectionTableGroup;
        DomainResultCreationStateImpl creationState = ResultsHelper.impl(domainResultCreationState);
        FromClauseAccess fromClauseAccess = domainResultCreationState.getSqlAstCreationState().getFromClauseAccess();
        if (fetchable instanceof PluralAttributeMapping) {
            collectionTableGroup = fromClauseAccess.getTableGroup(this.navigablePath);
            elementNavigablePath = this.navigablePath.append(CollectionPart.Nature.ELEMENT.getName());
        } else {
            collectionTableGroup = null;
            elementNavigablePath = this.navigablePath;
        }
        TableGroup tableGroup = fromClauseAccess.resolveTableGroup(elementNavigablePath, np -> {
            if (this.lockMode != null) {
                domainResultCreationState.getSqlAstCreationState().registerLockMode(this.tableAlias, this.lockMode);
            }
            return this.entityMapping.createRootTableGroup(true, this.navigablePath, this.tableAlias, new SqlAliasBaseConstant(this.tableAlias), null, creationState);
        });
        TableReference tableReference = tableGroup.getPrimaryTableReference();
        FetchBuilder idFetchBuilder = this.findIdFetchBuilder();
        List<String> keyColumnAliases = this.idColumnNames != null ? this.idColumnNames : (idFetchBuilder != null ? ((DynamicFetchBuilder)idFetchBuilder).getColumnAliases() : null);
        if (keyColumnAliases != null) {
            TableGroup keyTableGroup;
            ValuedModelPart keyPart;
            if (fetchable instanceof PluralAttributeMapping) {
                PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                if (pluralAttributeMapping.getCollectionDescriptor().isOneToMany()) {
                    keyPart = this.entityMapping.getIdentifierMapping();
                    keyTableGroup = tableGroup;
                } else {
                    List<String> idColumnAliases;
                    ManyToManyCollectionPart elementDescriptor = (ManyToManyCollectionPart)pluralAttributeMapping.getElementDescriptor();
                    keyPart = elementDescriptor.getForeignKeyDescriptor().getKeyPart();
                    keyTableGroup = collectionTableGroup;
                    if (idFetchBuilder instanceof DynamicFetchBuilder) {
                        DynamicFetchBuilder dynamicFetchBuilder = (DynamicFetchBuilder)idFetchBuilder;
                        idColumnAliases = dynamicFetchBuilder.getColumnAliases();
                    } else if (idFetchBuilder instanceof CompleteFetchBuilder) {
                        CompleteFetchBuilder completeFetchBuilder = (CompleteFetchBuilder)idFetchBuilder;
                        idColumnAliases = completeFetchBuilder.getColumnAliases();
                    } else {
                        throw new AssertionFailure("Unexpected fetch builder");
                    }
                    this.entityMapping.getIdentifierMapping().forEachSelectable((selectionIndex, selectableMapping) -> this.resolveSqlSelection((String)idColumnAliases.get(selectionIndex), tableReference, selectableMapping, jdbcResultsMetadata, domainResultCreationState));
                }
            } else {
                keyPart = this.entityMapping.getIdentifierMapping();
                keyTableGroup = tableGroup;
            }
            keyPart.forEachSelectable((selectionIndex, selectableMapping) -> this.resolveSqlSelection((String)keyColumnAliases.get(selectionIndex), keyTableGroup.resolveTableReference(selectableMapping.getContainingTableExpression()), selectableMapping, jdbcResultsMetadata, domainResultCreationState));
        }
        if (this.discriminatorColumnName != null) {
            DynamicResultBuilderEntityStandard.resolveDiscriminatorSqlSelection(this.discriminatorColumnName, tableReference, this.entityMapping.getDiscriminatorMapping(), jdbcResultsMetadata, domainResultCreationState);
        }
        try {
            creationState.pushExplicitFetchMementoResolver(f -> {
                if (f != null) {
                    return this.findFetchBuilder((Fetchable)f);
                }
                return null;
            });
            T t = resultOrFetchBuilder.apply(tableGroup);
            return t;
        }
        finally {
            creationState.popExplicitFetchMementoResolver();
        }
    }

    private static void resolveDiscriminatorSqlSelection(String columnAlias, TableReference tableReference, EntityDiscriminatorMapping discriminatorMapping, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableReference, discriminatorMapping, columnAlias), discriminatorMapping.getJdbcMapping().getJdbcJavaType(), null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getTypeConfiguration());
    }

    private FetchBuilder findIdFetchBuilder() {
        return this.findFetchBuilder(this.entityMapping.getIdentifierMapping());
    }

    private void resolveSqlSelection(String columnAlias, TableReference tableReference, SelectableMapping selectableMapping, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableReference, selectableMapping, columnAlias), selectableMapping.getJdbcMapping().getJdbcJavaType(), null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getTypeConfiguration());
    }

    @Override
    public DynamicResultBuilderEntityStandard setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    @Override
    public DynamicResultBuilderEntityStandard setDiscriminatorAlias(String columnName) {
        this.discriminatorColumnName = columnName;
        return this;
    }

    @Override
    public NativeQuery.RootReturn addProperty(String propertyName, String columnAlias) {
        ModelPart subPart = this.entityMapping.findSubPart(propertyName);
        this.addProperty((Fetchable)subPart, columnAlias);
        return this;
    }

    @Override
    public NativeQuery.ReturnProperty addProperty(String propertyName) {
        return this.addProperty((Fetchable)this.entityMapping.findSubPart(propertyName));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.navigablePath.hashCode();
        result = 31 * result + this.entityMapping.hashCode();
        result = 31 * result + this.tableAlias.hashCode();
        result = 31 * result + (this.lockMode != null ? this.lockMode.hashCode() : 0);
        result = 31 * result + (this.idColumnNames != null ? this.idColumnNames.hashCode() : 0);
        result = 31 * result + (this.discriminatorColumnName != null ? this.discriminatorColumnName.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicResultBuilderEntityStandard that = (DynamicResultBuilderEntityStandard)o;
        return this.navigablePath.equals(that.navigablePath) && this.entityMapping.equals(that.entityMapping) && this.tableAlias.equals(that.tableAlias) && this.lockMode == that.lockMode && Objects.equals(this.idColumnNames, that.idColumnNames) && Objects.equals(this.discriminatorColumnName, that.discriminatorColumnName) && super.equals(o);
    }
}

