/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingFunctionSqlAstExpression<T>
implements SelfRenderingExpression,
SqlExpressible,
DomainResultProducer<T>,
FunctionExpression {
    private final String functionName;
    private final FunctionRenderer renderer;
    private final List<? extends SqlAstNode> sqlAstArguments;
    private final @Nullable ReturnableType<T> type;
    private final @Nullable JdbcMappingContainer expressible;

    public SelfRenderingFunctionSqlAstExpression(String functionName, FunctionRenderer renderer, List<? extends SqlAstNode> sqlAstArguments, @Nullable ReturnableType<T> type, @Nullable JdbcMappingContainer expressible) {
        this.functionName = functionName;
        this.renderer = renderer;
        this.sqlAstArguments = sqlAstArguments;
        this.type = type;
        this.expressible = expressible;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public List<? extends SqlAstNode> getArguments() {
        return this.sqlAstArguments;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.type instanceof SqlExpressible ? (JdbcMappingContainer)((Object)this.type) : this.expressible;
    }

    FunctionRenderer getFunctionRenderer() {
        return this.renderer;
    }

    @Nullable ReturnableType<?> getType() {
        return this.type;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaType, boolean virtual, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, this, virtual);
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        BasicValueConverter<?, ?> converter;
        JavaType<Object> jdbcJavaType;
        JdbcMapping jdbcMapping = this.getJdbcMapping();
        if (jdbcMapping != null) {
            jdbcJavaType = jdbcMapping.getJdbcJavaType();
            converter = jdbcMapping.getValueConverter();
        } else if (this.type != null) {
            jdbcJavaType = this.type.getExpressibleJavaType();
            converter = null;
        } else {
            jdbcJavaType = null;
            converter = null;
        }
        return new BasicResult(this.resolveSqlSelection(creationState, jdbcJavaType).getValuesArrayPosition(), resultVariable, this.type == null ? null : this.type.getExpressibleJavaType(), converter, null, false, false);
    }

    @Override
    public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
        this.renderer.render(sqlAppender, this.sqlAstArguments, this.type, walker);
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        Object object = this.type;
        if (object instanceof SqlExpressible) {
            SqlExpressible sqlExpressible = (SqlExpressible)object;
            return sqlExpressible.getJdbcMapping();
        }
        object = this.expressible;
        if (object instanceof SqlExpressible) {
            SqlExpressible sqlExpressible = (SqlExpressible)object;
            return sqlExpressible.getJdbcMapping();
        }
        return null;
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        JdbcMapping jdbcMapping = this.getJdbcMapping();
        this.resolveSqlSelection(creationState, jdbcMapping == null ? this.type.getExpressibleJavaType() : jdbcMapping.getJdbcJavaType());
    }

    private SqlSelection resolveSqlSelection(DomainResultCreationState creationState, JavaType<?> javaType) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TypeConfiguration typeConfiguration = sqlAstCreationState.getCreationContext().getMappingMetamodel().getTypeConfiguration();
        return sqlAstCreationState.getSqlExpressionResolver().resolveSqlSelection(this, javaType, null, typeConfiguration);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new UnsupportedOperationException();
    }
}

