/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import jakarta.persistence.metamodel.Bindable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SelectableMappingExpressionConverter;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.jboss.logging.Logger;

public class MatchingIdSelectionHelper {
    private static final Logger log = Logger.getLogger(MatchingIdSelectionHelper.class);

    public static SelectStatement generateMatchingIdSelectStatement(EntityMappingType targetEntityDescriptor, SqmDeleteOrUpdateStatement<?> sqmStatement, boolean queryRoot, Predicate restriction, MultiTableSqmMutationConverter sqmConverter, DomainQueryExecutionContext executionContext) {
        Bindable entityDomainType = ((SqmRoot)sqmStatement.getTarget()).getModel();
        if (log.isTraceEnabled()) {
            log.tracef("Starting generation of entity-id SQM selection - %s", (Object)entityDomainType.getHibernateEntityName());
        }
        QuerySpec idSelectionQuery = new QuerySpec(queryRoot, 1);
        idSelectionQuery.applyPredicate(restriction);
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        idSelectionQuery.getFromClause().addRoot(mutatingTableGroup);
        ArrayList domainResults = new ArrayList();
        sqmConverter.getProcessingStateStack().push(new SqlAstQueryPartProcessingStateImpl(idSelectionQuery, sqmConverter.getCurrentProcessingState(), sqmConverter.getSqlAstCreationState(), sqmConverter.getCurrentClauseStack()::getCurrent, false));
        targetEntityDescriptor.getIdentifierMapping().applySqlSelections(mutatingTableGroup.getNavigablePath(), mutatingTableGroup, sqmConverter, (selection, jdbcMapping) -> domainResults.add(new BasicResult(selection.getValuesArrayPosition(), null, (JdbcMapping)jdbcMapping)));
        sqmConverter.getProcessingStateStack().pop();
        targetEntityDescriptor.getEntityPersister().applyBaseRestrictions(idSelectionQuery::applyPredicate, mutatingTableGroup, true, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), false, null, sqmConverter);
        return new SelectStatement(idSelectionQuery, domainResults);
    }

    public static SqmSelectStatement<?> generateMatchingIdSelectStatement(SqmDeleteOrUpdateStatement<?> sqmStatement, EntityMappingType entityDescriptor) {
        NodeBuilder nodeBuilder = sqmStatement.nodeBuilder();
        SqmQuerySpec sqmQuerySpec = new SqmQuerySpec(nodeBuilder);
        sqmQuerySpec.setFromClause(new SqmFromClause(1));
        sqmQuerySpec.addRoot(sqmStatement.getTarget());
        sqmQuerySpec.setSelectClause(new SqmSelectClause(false, 1, sqmQuerySpec.nodeBuilder()));
        entityDescriptor.getIdentifierMapping().forEachSelectable(0, (selectionIndex, selectableMapping) -> sqmQuerySpec.getSelectClause().addSelection(SelectableMappingExpressionConverter.forSelectableMapping(sqmStatement.getTarget(), selectableMapping)));
        sqmQuerySpec.setWhereClause(sqmStatement.getWhereClause());
        return new SqmSelectStatement<Object[]>(sqmQuerySpec, Object[].class, SqmQuerySource.CRITERIA, nodeBuilder);
    }

    public static CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> createMatchingIdsSelect(SqmDeleteOrUpdateStatement<?> sqmMutationStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityPersister entityDescriptor = factory.getMappingMetamodel().getEntityDescriptor(((SqmRoot)sqmMutationStatement.getTarget()).getModel().getHibernateEntityName());
        SqmSelectStatement<?> sqmSelectStatement = MatchingIdSelectionHelper.generateMatchingIdSelectStatement(sqmMutationStatement, entityDescriptor);
        JpaQueryStructure sqmQuerySpec = sqmSelectStatement.getQuerySpec();
        if (sqmMutationStatement instanceof SqmDeleteStatement) {
            entityDescriptor.visitSubTypeAttributeMappings(arg_0 -> MatchingIdSelectionHelper.lambda$createMatchingIdsSelect$3((SqmQuerySpec)sqmQuerySpec, sqmMutationStatement, arg_0));
        }
        SqmTranslator<SelectStatement> translator = factory.getQueryEngine().getSqmTranslatorFactory().createSelectTranslator(sqmSelectStatement, executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), factory.getSqlTranslationEngine(), true);
        final SqmTranslation<SelectStatement> translation = translator.translate();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslator<JdbcOperationQuerySelect> sqlAstSelectTranslator = jdbcEnvironment.getSqlAstTranslatorFactory().buildSelectTranslator(factory, translation.getSqlAst());
        Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, translator);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return translation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, executionContext.getSession());
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions().makeCopy();
        LockMode lockMode = lockOptions.getLockMode();
        lockOptions.setLockMode(LockMode.WRITE);
        if (!jdbcEnvironment.getDialect().supportsOuterJoinForUpdate()) {
            translation.getSqlAst().getQuerySpec().getFromClause().visitTableJoins(tableJoin -> {
                if (tableJoin.isInitialized() && tableJoin.getJoinType() != SqlAstJoinType.INNER) {
                    lockOptions.setLockMode(lockMode);
                }
            });
        }
        firstJdbcParameterBindingsConsumer.set(jdbcParameterBindings);
        return new CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect>(translation.getSqlAst(), sqlAstSelectTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions()), jdbcParamsXref, translation.getSqmParameterMappingModelTypeResolutions());
    }

    public static List<Object> selectMatchingIds(SqmDeleteOrUpdateStatement<?> sqmMutationStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext) {
        MutableObject<JdbcParameterBindings> jdbcParameterBindings = new MutableObject<JdbcParameterBindings>();
        CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> interpretation = MatchingIdSelectionHelper.createMatchingIdsSelect(sqmMutationStatement, domainParameterXref, executionContext, jdbcParameterBindings);
        return MatchingIdSelectionHelper.selectMatchingIds(interpretation, jdbcParameterBindings.get(), executionContext);
    }

    public static List<Object> selectMatchingIds(CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> interpretation, JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext executionContext) {
        RowTransformerArrayImpl rowTransformer = interpretation.statement().getDomainResultDescriptors().size() == 1 ? RowTransformerSingularReturnImpl.instance() : RowTransformerArrayImpl.instance();
        return executionContext.getSession().getFactory().getJdbcServices().getJdbcSelectExecutor().list(interpretation.jdbcOperation(), jdbcParameterBindings, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext), rowTransformer, ListResultsConsumer.UniqueSemantic.FILTER);
    }

    private static /* synthetic */ void lambda$createMatchingIdsSelect$3(SqmQuerySpec sqmQuerySpec, SqmDeleteOrUpdateStatement sqmMutationStatement, AttributeMapping attribute) {
        PluralAttributeMapping pluralAttribute;
        if (attribute instanceof PluralAttributeMapping && (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null) {
            boolean useFkTarget;
            ValuedModelPart targetPart = pluralAttribute.getKeyDescriptor().getTargetPart();
            boolean bl = useFkTarget = !targetPart.isEntityIdentifierMapping();
            if (useFkTarget) {
                targetPart.forEachSelectable(0, (selectionIndex, selectableMapping) -> sqmQuerySpec.getSelectClause().addSelection(SelectableMappingExpressionConverter.forSelectableMapping(sqmMutationStatement.getTarget(), selectableMapping)));
            }
        }
    }
}

