/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.internal;

import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutationGroup;
import org.hibernate.sql.model.internal.EntityMutationOperationGroupStandard;
import org.hibernate.sql.model.internal.MutationOperationGroupStandard;

public final class MutationOperationGroupFactory {
    public static MutationOperationGroup noOperations(MutationType mutationType, MutationTarget mutationTarget) {
        if (mutationTarget instanceof EntityMutationTarget) {
            EntityMutationTarget entityMutationTarget = (EntityMutationTarget)mutationTarget;
            return new EntityMutationOperationGroupStandard(mutationType, entityMutationTarget);
        }
        return new MutationOperationGroupStandard(mutationType, mutationTarget);
    }

    public static MutationOperationGroup noOperations(MutationGroup mutationGroup) {
        return MutationOperationGroupFactory.noOperations(mutationGroup.getMutationType(), mutationGroup.getMutationTarget());
    }

    public static MutationOperationGroup singleOperation(MutationType mutationType, MutationTarget mutationTarget, MutationOperation operation) {
        if (mutationTarget instanceof EntityMutationTarget) {
            EntityMutationTarget entityMutationTarget = (EntityMutationTarget)mutationTarget;
            return new EntityMutationOperationGroupStandard(mutationType, entityMutationTarget, operation);
        }
        return new MutationOperationGroupStandard(mutationType, mutationTarget, operation);
    }

    public static MutationOperationGroup singleOperation(MutationGroup mutationGroup, MutationOperation operation) {
        return MutationOperationGroupFactory.singleOperation(mutationGroup.getMutationType(), mutationGroup.getMutationTarget(), operation);
    }

    public static MutationOperationGroup manyOperations(MutationType mutationType, MutationTarget mutationTarget, MutationOperation[] operations) {
        if (mutationTarget instanceof EntityMutationTarget) {
            EntityMutationTarget entityMutationTarget = (EntityMutationTarget)mutationTarget;
            return new EntityMutationOperationGroupStandard(mutationType, entityMutationTarget, operations);
        }
        return new MutationOperationGroupStandard(mutationType, mutationTarget, operations);
    }
}

