/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterCharacterData;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class NVarcharJdbcType
implements AdjustableJdbcType {
    public static final NVarcharJdbcType INSTANCE = new NVarcharJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return -9;
    }

    @Override
    public String getFriendlyName() {
        return "NVARCHAR";
    }

    public String toString() {
        return "NVarcharTypeDescriptor";
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        if (length != null && length == 1) {
            return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Character.class));
        }
        return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)String.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterCharacterData<T>(javaType, true);
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        assert (domainJtd != null);
        TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
        JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
        int jdbcTypeCode = indicators.isLob() ? (indicators.isNationalized() ? 2011 : 2005) : (this.shouldUseMaterializedLob(indicators) ? (indicators.isNationalized() ? 3006 : 3005) : (indicators.isNationalized() ? -9 : 12));
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    protected boolean shouldUseMaterializedLob(JdbcTypeIndicators indicators) {
        Dialect dialect = indicators.getDialect();
        long length = indicators.getColumnLength();
        long maxLength = indicators.isNationalized() ? (long)dialect.getMaxNVarcharCapacity() : (long)dialect.getMaxVarcharCapacity();
        return length > maxLength && dialect.useMaterializedLobWhenCapacityExceeded();
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return String.class;
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                if (options.getDialect().supportsNationalizedMethods()) {
                    try {
                        st.setNString(index, javaType.unwrap(value, String.class, options));
                    }
                    catch (AbstractMethodError e) {
                        st.setBytes(index, javaType.unwrap(value, byte[].class, options));
                    }
                } else {
                    st.setString(index, javaType.unwrap(value, String.class, options));
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                if (options.getDialect().supportsNationalizedMethods()) {
                    st.setNString(name, javaType.unwrap(value, String.class, options));
                } else {
                    st.setString(name, javaType.unwrap(value, String.class, options));
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                if (options.getDialect().supportsNationalizedMethods()) {
                    try {
                        return javaType.wrap(rs.getNString(paramIndex), options);
                    }
                    catch (AbstractMethodError e) {
                        return javaType.wrap(rs.getBytes(paramIndex), options);
                    }
                }
                return javaType.wrap(rs.getString(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                if (options.getDialect().supportsNationalizedMethods()) {
                    return javaType.wrap(statement.getNString(index), options);
                }
                return javaType.wrap(statement.getString(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                if (options.getDialect().supportsNationalizedMethods()) {
                    return javaType.wrap(statement.getNString(name), options);
                }
                return javaType.wrap(statement.getString(name), options);
            }
        };
    }
}

