/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.StructAttributeValues;

@Internal
public class StructHelper {
    public static StructAttributeValues getAttributeValues(EmbeddableMappingType embeddableMappingType, Object[] rawJdbcValues, WrapperOptions options) throws SQLException {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        int size = numberOfAttributeMappings + (embeddableMappingType.isPolymorphic() ? 1 : 0);
        StructAttributeValues attributeValues = new StructAttributeValues(numberOfAttributeMappings, rawJdbcValues);
        int jdbcIndex = 0;
        for (int i = 0; i < size; ++i) {
            jdbcIndex += StructHelper.injectAttributeValue(StructHelper.getSubPart(embeddableMappingType, i), attributeValues, i, rawJdbcValues, jdbcIndex, options);
        }
        return attributeValues;
    }

    private static int injectAttributeValue(ValuedModelPart modelPart, StructAttributeValues attributeValues, int attributeIndex, Object[] rawJdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        MappingType mappingType = modelPart.getMappedType();
        if (mappingType instanceof EmbeddableMappingType) {
            EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappingType;
            return StructHelper.injectAttributeValueEmbeddable(attributeValues, attributeIndex, rawJdbcValues, jdbcIndex, options, embeddableMappingType);
        }
        assert (modelPart.getJdbcTypeCount() == 1);
        return StructHelper.injectAttributeValueSimple(modelPart, attributeValues, attributeIndex, rawJdbcValues, jdbcIndex, options);
    }

    private static int injectAttributeValueSimple(ValuedModelPart modelPart, StructAttributeValues attributeValues, int attributeIndex, Object[] rawJdbcValues, int jdbcIndex, WrapperOptions options) {
        JdbcMapping jdbcMapping = modelPart.getSingleJdbcMapping();
        Object jdbcValue = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValues[jdbcIndex], options);
        attributeValues.setAttributeValue(attributeIndex, jdbcMapping.convertToDomainValue(jdbcValue));
        return 1;
    }

    private static int injectAttributeValueEmbeddable(StructAttributeValues attributeValues, int attributeIndex, Object[] rawJdbcValues, int jdbcIndex, WrapperOptions options, EmbeddableMappingType embeddableMappingType) throws SQLException {
        if (embeddableMappingType.getAggregateMapping() != null) {
            attributeValues.setAttributeValue(attributeIndex, rawJdbcValues[jdbcIndex]);
            return 1;
        }
        int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
        Object[] subJdbcValues = new Object[jdbcValueCount];
        System.arraycopy(rawJdbcValues, jdbcIndex, subJdbcValues, 0, subJdbcValues.length);
        StructAttributeValues subValues = StructHelper.getAttributeValues(embeddableMappingType, subJdbcValues, options);
        attributeValues.setAttributeValue(attributeIndex, StructHelper.instantiate(embeddableMappingType, subValues));
        return jdbcValueCount;
    }

    public static Object[] getJdbcValues(EmbeddableMappingType embeddableMappingType, int[] orderMapping, Object domainValue, WrapperOptions options) throws SQLException {
        int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
        int valueCount = jdbcValueCount + (embeddableMappingType.isPolymorphic() ? 1 : 0);
        Object[] values = embeddableMappingType.getValues(domainValue);
        Object[] jdbcValues = valueCount != values.length || orderMapping != null ? new Object[valueCount] : values;
        StructHelper.injectJdbcValues(embeddableMappingType, values, jdbcValues, 0, options);
        if (orderMapping != null) {
            Object[] originalJdbcValues = (Object[])jdbcValues.clone();
            for (int i = 0; i < orderMapping.length; ++i) {
                jdbcValues[i] = originalJdbcValues[orderMapping[i]];
            }
        }
        return jdbcValues;
    }

    private static int injectJdbcValues(EmbeddableMappingType embeddableMappingType, @Nullable Object domainValue, Object[] jdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        return StructHelper.injectJdbcValues(embeddableMappingType, domainValue == null ? null : embeddableMappingType.getValues(domainValue), jdbcValues, jdbcIndex, options);
    }

    private static int injectJdbcValues(EmbeddableMappingType embeddableMappingType, @Nullable Object[] values, Object[] jdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
        int valueCount = jdbcValueCount + (embeddableMappingType.isPolymorphic() ? 1 : 0);
        if (values == null) {
            return valueCount;
        }
        int offset = 0;
        for (int i = 0; i < values.length; ++i) {
            offset += StructHelper.injectJdbcValue(StructHelper.getSubPart(embeddableMappingType, i), values, i, jdbcValues, jdbcIndex + offset, options);
        }
        assert (offset == valueCount);
        return offset;
    }

    public static Object instantiate(EmbeddableMappingType embeddableMappingType, StructAttributeValues attributeValues) {
        return StructHelper.embeddableInstantiator(embeddableMappingType, attributeValues).instantiate(attributeValues);
    }

    private static EmbeddableInstantiator embeddableInstantiator(EmbeddableMappingType embeddableMappingType, StructAttributeValues attributeValues) {
        EmbeddableRepresentationStrategy representationStrategy = embeddableMappingType.getRepresentationStrategy();
        if (!embeddableMappingType.isPolymorphic()) {
            return representationStrategy.getInstantiator();
        }
        Class discriminatorClass = (Class)attributeValues.getDiscriminator();
        return representationStrategy.getInstantiatorForClass(discriminatorClass.getName());
    }

    public static ValuedModelPart getSubPart(ManagedMappingType type, int position) {
        if (position == type.getNumberOfAttributeMappings()) {
            assert (type instanceof EmbeddableMappingType) : "Unexpected position for non-embeddable type: " + String.valueOf(type);
            return ((EmbeddableMappingType)type).getDiscriminatorMapping();
        }
        return type.getAttributeMapping(position);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int injectJdbcValue(ValuedModelPart attributeMapping, Object[] attributeValues, int attributeIndex, Object[] jdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int jdbcValueCount;
        if (attributeMapping instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
            if (toOneAttributeMapping.getSideNature() == ForeignKeyDescriptor.Nature.TARGET) {
                return 0;
            }
            ForeignKeyDescriptor foreignKeyDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
            ValuedModelPart keyPart = foreignKeyDescriptor.getKeyPart();
            Object foreignKeyValue = foreignKeyDescriptor.getAssociationKeyFromSide(attributeValues[attributeIndex], ForeignKeyDescriptor.Nature.TARGET, options.getSession());
            if (keyPart instanceof BasicValuedMapping) {
                jdbcValueCount = 1;
                jdbcValues[jdbcIndex] = foreignKeyValue;
                return jdbcValueCount;
            }
            if (!(keyPart instanceof EmbeddableValuedModelPart)) throw new UnsupportedOperationException("Unsupported foreign key part: " + String.valueOf(keyPart));
            EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)keyPart;
            return StructHelper.injectJdbcValues(embeddableValuedModelPart.getEmbeddableTypeDescriptor(), foreignKeyValue, jdbcValues, jdbcIndex, options);
        }
        if (attributeMapping instanceof PluralAttributeMapping) {
            return 0;
        }
        if (attributeMapping instanceof DiscriminatedAssociationAttributeMapping) {
            return attributeMapping.decompose(attributeValues[attributeIndex], jdbcIndex, jdbcValues, options, (valueIndex, objects, wrapperOptions, value, jdbcValueMapping) -> {
                objects[valueIndex] = value;
            }, options.getSession());
        }
        if (attributeMapping instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)attributeMapping;
            EmbeddableMappingType embeddableMappingType = embeddableValuedModelPart.getMappedType();
            if (embeddableMappingType.getAggregateMapping() == null) return StructHelper.injectJdbcValues(embeddableMappingType, attributeValues[attributeIndex], jdbcValues, jdbcIndex, options);
            jdbcValueCount = 1;
            jdbcValues[jdbcIndex] = embeddableMappingType.getAggregateMapping().getJdbcMapping().getJdbcValueBinder().getBindValue(attributeValues[attributeIndex], options);
            return jdbcValueCount;
        }
        assert (attributeMapping.getJdbcTypeCount() == 1);
        jdbcValueCount = 1;
        JdbcMapping jdbcMapping = attributeMapping.getSingleJdbcMapping();
        Object relationalValue = jdbcMapping.convertToRelationalValue(attributeValues[attributeIndex]);
        if (relationalValue == null) return jdbcValueCount;
        JavaType<?> javaType = jdbcMapping.getJdbcJavaType();
        StructHelper.injectCastJdbcValue(jdbcValues, jdbcIndex, options, jdbcMapping, javaType, relationalValue);
        return jdbcValueCount;
    }

    private static <T> void injectCastJdbcValue(Object[] jdbcValues, int jdbcIndex, WrapperOptions options, JdbcMapping jdbcMapping, JavaType<T> javaType, Object relationalValue) throws SQLException {
        assert (javaType.isInstance(relationalValue));
        StructHelper.injectJdbcValue(jdbcValues, jdbcIndex, options, jdbcMapping, javaType, relationalValue);
    }

    private static <T> void injectJdbcValue(Object[] jdbcValues, int jdbcIndex, WrapperOptions options, JdbcMapping jdbcMapping, JavaType<T> javaType, T relationalValue) throws SQLException {
        jdbcValues[jdbcIndex] = switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case 2004, 3004 -> javaType.unwrap(relationalValue, Blob.class, options);
            case 2005, 3005 -> javaType.unwrap(relationalValue, Clob.class, options);
            case 2011, 3006 -> javaType.unwrap(relationalValue, NClob.class, options);
            default -> jdbcMapping.getJdbcValueBinder().getBindValue(relationalValue, options);
        };
    }

    public static void orderJdbcValues(EmbeddableMappingType embeddableMappingType, int[] inverseMapping, Object[] sourceJdbcValues, Object[] targetJdbcValues) {
        for (int i = 0; i < inverseMapping.length; ++i) {
            targetJdbcValues[i] = sourceJdbcValues[inverseMapping[i]];
        }
    }

    public static int getJdbcValueCount(MappingType mappedType) {
        EmbeddableMappingType subMappingType;
        return mappedType instanceof EmbeddableMappingType ? ((subMappingType = (EmbeddableMappingType)mappedType).getAggregateMapping() != null ? 1 : subMappingType.getJdbcValueCount()) : 1;
    }
}

