/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.internal;

import jakarta.persistence.TemporalType;
import java.sql.Time;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.spi.BasicJdbcLiteralFormatter;

public class JdbcLiteralFormatterTemporal<T>
extends BasicJdbcLiteralFormatter<T> {
    private final TemporalType precision;

    public JdbcLiteralFormatterTemporal(JavaType<T> javaType, TemporalType precision) {
        super(javaType);
        this.precision = precision;
    }

    @Override
    public void appendJdbcLiteral(SqlAppender appender, Object value, Dialect dialect, WrapperOptions options) {
        TimeZone jdbcTimeZone = JdbcLiteralFormatterTemporal.getJdbcTimeZone(options);
        if (value instanceof Date) {
            Date date = (Date)value;
            dialect.appendDateTimeLiteral(appender, date, this.precision, jdbcTimeZone);
        } else if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            dialect.appendDateTimeLiteral(appender, calendar, this.precision, jdbcTimeZone);
        } else if (value instanceof TemporalAccessor) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)value;
            dialect.appendDateTimeLiteral(appender, temporalAccessor, this.precision, jdbcTimeZone);
        } else {
            dialect.appendDateTimeLiteral(appender, this.unwrap(value, options), this.precision, jdbcTimeZone);
        }
    }

    private Date unwrap(Object value, WrapperOptions options) {
        return switch (this.precision) {
            default -> throw new IncompatibleClassChangeError();
            case TemporalType.DATE -> this.unwrap(value, java.sql.Date.class, options);
            case TemporalType.TIME -> this.unwrap(value, Time.class, options);
            case TemporalType.TIMESTAMP -> this.unwrap(value, Date.class, options);
        };
    }

    private static TimeZone getJdbcTimeZone(WrapperOptions options) {
        return options == null || options.getJdbcTimeZone() == null ? TimeZone.getDefault() : options.getJdbcTimeZone();
    }
}

