/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.format.AbstractJsonFormatMapper;

public final class JacksonJsonFormatMapper
extends AbstractJsonFormatMapper {
    public static final String SHORT_NAME = "jackson";
    private final ObjectMapper objectMapper;

    public JacksonJsonFormatMapper() {
        this(new ObjectMapper().findAndRegisterModules());
    }

    public JacksonJsonFormatMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> void writeToTarget(T value, JavaType<T> javaType, Object target, WrapperOptions options) throws IOException {
        this.objectMapper.writerFor(this.objectMapper.constructType(javaType.getJavaType())).writeValue((JsonGenerator)target, value);
    }

    @Override
    public <T> T readFromSource(JavaType<T> javaType, Object source, WrapperOptions options) throws IOException {
        return (T)this.objectMapper.readValue((JsonParser)source, this.objectMapper.constructType(javaType.getJavaType()));
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return JsonParser.class.isAssignableFrom(sourceType);
    }

    @Override
    public boolean supportsTargetType(Class<?> targetType) {
        return JsonGenerator.class.isAssignableFrom(targetType);
    }

    @Override
    public <T> T fromString(CharSequence charSequence, Type type) {
        try {
            return (T)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType(type));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + String.valueOf(type), e);
        }
    }

    @Override
    public <T> String toString(T value, Type type) {
        try {
            return this.objectMapper.writerFor(this.objectMapper.constructType(type)).writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + String.valueOf(type), e);
        }
    }
}

