/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.MappedDirectoryStream;
import io.smallrye.common.resource.Resource;
import io.smallrye.common.resource.ResourceURLStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;

public final class PathResource
extends Resource {
    private static final long MAP_THRESHOLD = 0x8000000L;
    private final Path path;
    private URL url;
    private MappedByteBuffer mapped;

    public PathResource(String pathName, Path path) {
        super(pathName);
        this.path = (Path)Assert.checkNotNullParam((String)"path", (Object)path);
    }

    public Path path() {
        return this.path;
    }

    @Override
    public URL url() {
        URL url = this.url;
        if (url == null) {
            try {
                URI pathUri = this.path.toUri();
                url = this.url = new URL(null, pathUri.toASCIIString(), new ResourceURLStreamHandler(this));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Unexpected URL problem", e);
            }
        }
        return url;
    }

    @Override
    public DirectoryStream<Resource> openDirectoryStream() throws IOException {
        return new MappedDirectoryStream<Path, Resource>(Files.newDirectoryStream(this.path), p -> new PathResource(this.pathName() + "/" + p.getFileName().toString(), (Path)p));
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer asBuffer() throws IOException {
        long size;
        MappedByteBuffer mapped = this.mapped;
        if (mapped == null && (size = this.size()) >= 0x8000000L) {
            PathResource pathResource = this;
            synchronized (pathResource) {
                mapped = this.mapped;
                if (mapped == null) {
                    try (FileChannel fc = FileChannel.open(this.path(), StandardOpenOption.READ);){
                        if (fc.size() > Integer.MAX_VALUE) {
                            throw new OutOfMemoryError("Resource is too large to load into a buffer");
                        }
                        mapped = this.mapped = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    }
                }
            }
        }
        if (mapped == null) {
            return ByteBuffer.wrap(Files.readAllBytes(this.path));
        }
        return mapped.duplicate();
    }

    @Override
    public String asString(Charset charset) throws IOException {
        return Files.readString(this.path(), charset);
    }

    @Override
    public Instant modifiedTime() {
        try {
            FileTime fileTime = Files.getLastModifiedTime(this.path(), new LinkOption[0]);
            return fileTime.toMillis() == 0L ? null : fileTime.toInstant();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public long size() {
        MappedByteBuffer mapped = this.mapped;
        if (mapped != null) {
            return mapped.capacity();
        }
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            return -1L;
        }
    }
}

