/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfGraph;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import com.apicatalog.rdf.RdfValue;
import com.apicatalog.rdf.io.RdfReader;
import com.apicatalog.rdf.io.RdfWriter;
import com.apicatalog.rdf.io.error.UnsupportedContentException;
import com.apicatalog.rdf.spi.RdfProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;

public final class Rdf {
    private Rdf() {
    }

    public static final RdfGraph createGraph() {
        return RdfProvider.provider().createGraph();
    }

    public static final Collection<MediaType> canRead() {
        return RdfProvider.provider().canRead();
    }

    public static final RdfReader createReader(MediaType contentType, Reader reader) throws UnsupportedContentException {
        if (reader == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createReader(contentType, reader);
    }

    public static final RdfReader createReader(MediaType contentType, InputStream is) throws UnsupportedContentException {
        if (is == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        return Rdf.createReader(contentType, new InputStreamReader(is));
    }

    public static final Collection<MediaType> canWrite() {
        return RdfProvider.provider().canWrite();
    }

    public static final RdfWriter createWriter(MediaType contentType, Writer writer) throws UnsupportedContentException {
        if (writer == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createWriter(contentType, writer);
    }

    public static final RdfWriter createWriter(MediaType contentType, OutputStream os) throws UnsupportedContentException {
        if (os == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        return Rdf.createWriter(contentType, new OutputStreamWriter(os));
    }

    public static final RdfDataset createDataset() {
        return RdfProvider.provider().createDataset();
    }

    public static final RdfTriple createTriple(RdfResource subject, RdfResource predicate, RdfValue object) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createTriple(subject, predicate, object);
    }

    public static final RdfNQuad createNQuad(RdfResource subject, RdfResource predicate, RdfValue object, RdfResource graphName) {
        if (subject == null) {
            throw new IllegalArgumentException("Subject cannot be null.");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        return RdfProvider.provider().createNQuad(subject, predicate, object, graphName);
    }

    public static final RdfNQuad createNQuad(RdfTriple triple, RdfResource graphName) {
        if (triple == null) {
            throw new IllegalArgumentException("Triple cannot be null.");
        }
        return RdfProvider.provider().createNQuad(triple.getSubject(), triple.getPredicate(), triple.getObject(), graphName);
    }

    public static RdfValue createValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (BlankNode.isWellFormed(value)) {
            return RdfProvider.provider().createBlankNode(value);
        }
        if (UriUtils.isAbsoluteUri(value, true)) {
            return RdfProvider.provider().createIRI(value);
        }
        return RdfProvider.provider().createTypedString(value, "http://www.w3.org/2001/XMLSchema#string");
    }

    public static RdfLiteral createString(String lexicalForm) {
        if (lexicalForm == null) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createTypedString(lexicalForm, "http://www.w3.org/2001/XMLSchema#string");
    }

    public static RdfLiteral createTypedString(String lexicalForm, String dataType) {
        if (lexicalForm == null) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createTypedString(lexicalForm, dataType);
    }

    public static RdfLiteral createLangString(String lexicalForm, String langTag) {
        if (lexicalForm == null) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createLangString(lexicalForm, langTag);
    }

    public static RdfResource createResource(String resource) {
        if (resource == null) {
            throw new IllegalArgumentException("The resource value cannot be null.");
        }
        if (BlankNode.isWellFormed(resource)) {
            return RdfProvider.provider().createBlankNode(resource);
        }
        if (UriUtils.isAbsoluteUri(resource, true)) {
            return RdfProvider.provider().createIRI(resource);
        }
        throw new IllegalArgumentException("The resource must be an absolute IRI or blank node identifier, but was [" + resource + "].");
    }

    public static RdfResource createBlankNode(String value) {
        if (value == null || StringUtils.isBlank(value)) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createBlankNode(value);
    }

    public static RdfResource createIRI(String value) {
        if (value == null || StringUtils.isBlank(value)) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createIRI(value);
    }
}

