/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crl.infinispan;

import org.infinispan.Cache;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.crl.infinispan.X509CRLEntry;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.cache.CacheCrlProvider;
import org.keycloak.models.cache.infinispan.ClearCacheEvent;

public class InfinispanCacheCrlProvider
implements CacheCrlProvider {
    private final KeycloakSession session;
    private final Cache<String, X509CRLEntry> crlCache;

    public InfinispanCacheCrlProvider(KeycloakSession session, Cache<String, X509CRLEntry> crlCache) {
        this.session = session;
        this.crlCache = crlCache;
    }

    public void clearCache() {
        this.crlCache.clear();
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify("CRL_CLEAR_CACHE_EVENTS", (ClusterEvent)ClearCacheEvent.getInstance(), true);
    }

    public void close() {
    }
}

