/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.cache.infinispan.authorization.entities.InResourceServer;
import org.keycloak.models.cache.infinispan.authorization.entities.ResourceQuery;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;

public class ResourceListQuery
extends AbstractRevisioned
implements ResourceQuery,
InResourceServer {
    private final Set<String> resources;
    private final String serverId;

    public ResourceListQuery(Long revision, String id, String resourceId, String serverId) {
        super(revision, id);
        this.serverId = serverId;
        this.resources = new HashSet<String>();
        this.resources.add(resourceId);
    }

    public ResourceListQuery(Long revision, String id, Set<String> resources, String serverId) {
        super(revision, id);
        this.serverId = serverId;
        this.resources = resources;
    }

    @Override
    public String getResourceServerId() {
        return this.serverId;
    }

    @Override
    public Set<String> getResources() {
        return this.resources;
    }

    @Override
    public boolean isInvalid(Set<String> invalidations) {
        return invalidations.contains(this.getId()) || invalidations.contains(this.getResourceServerId());
    }
}

