/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.sessions.infinispan.SessionEntityUpdater;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class AuthenticationSessionAdapter
implements AuthenticationSessionModel {
    private final KeycloakSession session;
    private final RootAuthenticationSessionModel parent;
    private final SessionEntityUpdater<AuthenticationSessionEntity> updater;
    private final String tabId;

    public AuthenticationSessionAdapter(KeycloakSession session, RootAuthenticationSessionModel parent, SessionEntityUpdater<AuthenticationSessionEntity> updater, String tabId) {
        this.session = session;
        this.parent = parent;
        this.updater = updater;
        this.tabId = tabId;
    }

    private void update() {
        this.updater.onEntityUpdated();
    }

    public String getTabId() {
        return this.tabId;
    }

    public RootAuthenticationSessionModel getParentSession() {
        return this.parent;
    }

    public RealmModel getRealm() {
        return this.parent.getRealm();
    }

    public ClientModel getClient() {
        return this.getRealm().getClientById(this.updater.getEntity().getClientUUID());
    }

    public String getRedirectUri() {
        return this.updater.getEntity().getRedirectUri();
    }

    public void setRedirectUri(String uri) {
        this.updater.getEntity().setRedirectUri(uri);
        this.update();
    }

    public String getAction() {
        return this.updater.getEntity().getAction();
    }

    public void setAction(String action) {
        this.updater.getEntity().setAction(action);
        this.update();
    }

    public Set<String> getClientScopes() {
        if (this.updater.getEntity().getClientScopes() == null || this.updater.getEntity().getClientScopes().isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.updater.getEntity().getClientScopes());
    }

    public void setClientScopes(Set<String> clientScopes) {
        this.updater.getEntity().setClientScopes(clientScopes);
        this.update();
    }

    public String getProtocol() {
        return this.updater.getEntity().getProtocol();
    }

    public void setProtocol(String protocol) {
        this.updater.getEntity().setProtocol(protocol);
        this.update();
    }

    public String getClientNote(String name) {
        return this.updater.getEntity().getClientNotes() != null && name != null ? this.updater.getEntity().getClientNotes().get(name) : null;
    }

    public void setClientNote(String name, String value) {
        if (this.updater.getEntity().getClientNotes() == null) {
            this.updater.getEntity().setClientNotes(new ConcurrentHashMap<String, String>());
        }
        if (name != null) {
            if (value == null) {
                this.updater.getEntity().getClientNotes().remove(name);
            } else {
                this.updater.getEntity().getClientNotes().put(name, value);
            }
        }
        this.update();
    }

    public void removeClientNote(String name) {
        if (this.updater.getEntity().getClientNotes() != null && name != null) {
            this.updater.getEntity().getClientNotes().remove(name);
        }
        this.update();
    }

    public Map<String, String> getClientNotes() {
        if (this.updater.getEntity().getClientNotes() == null || this.updater.getEntity().getClientNotes().isEmpty()) {
            return Collections.emptyMap();
        }
        return new ConcurrentHashMap<String, String>(this.updater.getEntity().getClientNotes());
    }

    public void clearClientNotes() {
        this.updater.getEntity().setClientNotes(new ConcurrentHashMap<String, String>());
        this.update();
    }

    public String getAuthNote(String name) {
        return this.updater.getEntity().getAuthNotes() != null && name != null ? this.updater.getEntity().getAuthNotes().get(name) : null;
    }

    public void setAuthNote(String name, String value) {
        if (this.updater.getEntity().getAuthNotes() == null) {
            this.updater.getEntity().setAuthNotes(new ConcurrentHashMap<String, String>());
        }
        if (name != null) {
            if (value == null) {
                this.updater.getEntity().getAuthNotes().remove(name);
            } else {
                this.updater.getEntity().getAuthNotes().put(name, value);
            }
        }
        this.update();
    }

    public void removeAuthNote(String name) {
        if (this.updater.getEntity().getAuthNotes() != null && name != null) {
            this.updater.getEntity().getAuthNotes().remove(name);
        }
        this.update();
    }

    public void clearAuthNotes() {
        this.updater.getEntity().setAuthNotes(new ConcurrentHashMap<String, String>());
        this.update();
    }

    public void setUserSessionNote(String name, String value) {
        if (this.updater.getEntity().getUserSessionNotes() == null) {
            this.updater.getEntity().setUserSessionNotes(new ConcurrentHashMap<String, String>());
        }
        if (name != null) {
            if (value == null) {
                this.updater.getEntity().getUserSessionNotes().remove(name);
            } else {
                this.updater.getEntity().getUserSessionNotes().put(name, value);
            }
        }
        this.update();
    }

    public Map<String, String> getUserSessionNotes() {
        if (this.updater.getEntity().getUserSessionNotes() == null) {
            return Collections.emptyMap();
        }
        return new ConcurrentHashMap<String, String>(this.updater.getEntity().getUserSessionNotes());
    }

    public void clearUserSessionNotes() {
        this.updater.getEntity().setUserSessionNotes(new ConcurrentHashMap<String, String>());
        this.update();
    }

    public Set<String> getRequiredActions() {
        return new HashSet<String>(this.updater.getEntity().getRequiredActions());
    }

    public void addRequiredAction(String action) {
        this.updater.getEntity().getRequiredActions().add(action);
        this.update();
    }

    public void removeRequiredAction(String action) {
        this.updater.getEntity().getRequiredActions().remove(action);
        this.update();
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.addRequiredAction(action.name());
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.removeRequiredAction(action.name());
    }

    public Map<String, CommonClientSessionModel.ExecutionStatus> getExecutionStatus() {
        return this.updater.getEntity().getExecutionStatus();
    }

    public void setExecutionStatus(String authenticator, CommonClientSessionModel.ExecutionStatus status) {
        this.updater.getEntity().getExecutionStatus().put(authenticator, status);
        this.update();
    }

    public void clearExecutionStatus() {
        this.updater.getEntity().getExecutionStatus().clear();
        this.update();
    }

    public UserModel getAuthenticatedUser() {
        if (this.updater.getEntity().getAuthUserId() == null) {
            return null;
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && this.getUserSessionNotes().containsKey("keycloak.userModel")) {
            LightweightUserAdapter cachedUser = (LightweightUserAdapter)this.session.getAttribute("authSession.user." + this.parent.getId(), LightweightUserAdapter.class);
            if (cachedUser != null) {
                return cachedUser;
            }
            LightweightUserAdapter lua = LightweightUserAdapter.fromString((KeycloakSession)this.session, (RealmModel)this.parent.getRealm(), (String)this.getUserSessionNotes().get("keycloak.userModel"));
            this.session.setAttribute("authSession.user." + this.parent.getId(), (Object)lua);
            lua.setUpdateHandler(lua1 -> {
                if (lua == lua1) {
                    this.setUserSessionNote("keycloak.userModel", lua1.serialize());
                }
            });
            return lua;
        }
        return this.session.users().getUserById(this.getRealm(), this.updater.getEntity().getAuthUserId());
    }

    public void setAuthenticatedUser(UserModel user) {
        if (user == null) {
            this.updater.getEntity().setAuthUserId(null);
            this.setUserSessionNote("keycloak.userModel", null);
        } else {
            this.updater.getEntity().setAuthUserId(user.getId());
            if (LightweightUserAdapter.isLightweightUser((UserModel)user)) {
                LightweightUserAdapter lua = (LightweightUserAdapter)user;
                this.setUserSessionNote("keycloak.userModel", lua.serialize());
                lua.setUpdateHandler(lua1 -> {
                    if (lua == lua1) {
                        this.setUserSessionNote("keycloak.userModel", lua1.serialize());
                    }
                });
            }
        }
        this.update();
    }

    public boolean equals(Object o) {
        AuthenticationSessionModel that;
        return this == o || o instanceof AuthenticationSessionModel && (that = (AuthenticationSessionModel)o).getTabId().equals(this.getTabId());
    }

    public int hashCode() {
        return this.getTabId().hashCode();
    }
}

