/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

@ProtoTypeId(value=65567)
public class UserSessionPredicate
implements Predicate<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>> {
    private final String realm;
    private String user;
    private String client;
    private String brokerSessionId;
    private String brokerUserId;

    private UserSessionPredicate(String realm) {
        this.realm = realm;
    }

    public static UserSessionPredicate create(String realm) {
        return new UserSessionPredicate(realm);
    }

    public UserSessionPredicate user(String user) {
        this.user = user;
        return this;
    }

    public UserSessionPredicate client(String clientUUID) {
        this.client = clientUUID;
        return this;
    }

    public UserSessionPredicate brokerSessionId(String id) {
        this.brokerSessionId = id;
        return this;
    }

    public UserSessionPredicate brokerUserId(String id) {
        this.brokerUserId = id;
        return this;
    }

    @ProtoField(value=1)
    public String getUserId() {
        return this.user;
    }

    @ProtoField(value=2)
    public String getBrokerSessionId() {
        return this.brokerSessionId;
    }

    @ProtoField(value=3)
    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    @ProtoField(value=4)
    String getRealm() {
        return this.realm;
    }

    @ProtoField(value=5)
    public String getClient() {
        return this.client;
    }

    @ProtoFactory
    static UserSessionPredicate create(String userId, String brokerSessionId, String brokerUserId, String realm, String client) {
        return UserSessionPredicate.create(realm).user(userId).client(client).brokerSessionId(brokerSessionId).brokerUserId(brokerUserId);
    }

    @Override
    public boolean test(Map.Entry<String, SessionEntityWrapper<UserSessionEntity>> entry) {
        UserSessionEntity entity = entry.getValue().getEntity();
        return !(!this.realm.equals(entity.getRealmId()) || this.user != null && !entity.getUser().equals(this.user) || this.client != null && !entity.getClientSessions().contains(this.client) || this.brokerSessionId != null && !this.brokerSessionId.equals(entity.getBrokerSessionId()) || this.brokerUserId != null && !this.brokerUserId.equals(entity.getBrokerUserId()));
    }

    public Predicate<? super UserSessionModel> toModelPredicate() {
        return entity -> !(entity == null || !this.realm.equals(entity.getRealm().getId()) || this.user != null && !entity.getUser().getId().equals(this.user) || this.client != null && (entity.getAuthenticatedClientSessions() == null || !entity.getAuthenticatedClientSessions().containsKey(this.client)) || this.brokerSessionId != null && !this.brokerSessionId.equals(entity.getBrokerSessionId()) || this.brokerUserId != null && !this.brokerUserId.equals(entity.getBrokerUserId()));
    }
}

