/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;

final class Mutations {
    private Mutations() {
    }

    static <K, V, T, R> void writeTo(ObjectOutput output, Mutation<K, V, R> mutation) throws IOException {
        BaseMutation bm = (BaseMutation)mutation;
        DataConversion.writeTo(output, bm.keyDataConversion);
        DataConversion.writeTo(output, bm.valueDataConversion);
        byte type = mutation.type();
        output.writeByte(type);
        switch (type) {
            case 0: {
                output.writeObject(((ReadWrite)mutation).f);
                break;
            }
            case 1: {
                ReadWriteWithValue rwwv = (ReadWriteWithValue)mutation;
                output.writeObject(rwwv.argument);
                output.writeObject(rwwv.f);
                break;
            }
            case 2: {
                output.writeObject(((Write)mutation).f);
                break;
            }
            case 3: {
                WriteWithValue wwv = (WriteWithValue)mutation;
                output.writeObject(wwv.argument);
                output.writeObject(wwv.f);
            }
        }
    }

    static <K, V, T> Mutation<K, V, ?> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        DataConversion keyDataConversion = DataConversion.readFrom(input);
        DataConversion valueDataConversion = DataConversion.readFrom(input);
        switch (input.readByte()) {
            case 0: {
                return new ReadWrite(keyDataConversion, valueDataConversion, (Function)input.readObject());
            }
            case 1: {
                return new ReadWriteWithValue(keyDataConversion, valueDataConversion, input.readObject(), (BiFunction)input.readObject());
            }
            case 2: {
                return new Write(keyDataConversion, valueDataConversion, (Consumer)input.readObject());
            }
            case 3: {
                return new WriteWithValue(keyDataConversion, valueDataConversion, input.readObject(), (BiConsumer)input.readObject());
            }
        }
        throw new IllegalStateException("Unknown type of mutation, broken input?");
    }

    static abstract class BaseMutation<K, V, R>
    implements Mutation<K, V, R> {
        protected final DataConversion keyDataConversion;
        protected final DataConversion valueDataConversion;

        BaseMutation(DataConversion keyDataConversion, DataConversion valueDataConversion) {
            this.keyDataConversion = keyDataConversion;
            this.valueDataConversion = valueDataConversion;
        }

        @Override
        public DataConversion keyDataConversion() {
            return this.keyDataConversion;
        }

        @Override
        public DataConversion valueDataConversion() {
            return this.valueDataConversion;
        }

        @Override
        public void inject(ComponentRegistry registry) {
            registry.wireDependencies(this.keyDataConversion);
            registry.wireDependencies(this.valueDataConversion);
        }
    }

    static class ReadWrite<K, V, R>
    extends BaseMutation<K, V, R> {
        static final byte TYPE = 0;
        private final Function<EntryView.ReadWriteEntryView<K, V>, R> f;

        public ReadWrite(DataConversion keyDataConversion, DataConversion valueDataConversion, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
            super(keyDataConversion, valueDataConversion);
            this.f = f;
        }

        @Override
        public void inject(ComponentRegistry registry) {
            super.inject(registry);
            if (this.f instanceof InjectableComponent) {
                ((InjectableComponent)((Object)this.f)).inject(registry);
            }
        }

        @Override
        public byte type() {
            return 0;
        }

        @Override
        public R apply(EntryView.ReadWriteEntryView<K, V> view) {
            return this.f.apply(view);
        }
    }

    static class ReadWriteWithValue<K, V, T, R>
    extends BaseMutation<K, V, R> {
        static final byte TYPE = 1;
        private final Object argument;
        private final BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f;

        public ReadWriteWithValue(DataConversion keyDataConversion, DataConversion valueDataConversion, Object argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f) {
            super(keyDataConversion, valueDataConversion);
            this.argument = argument;
            this.f = f;
        }

        @Override
        public byte type() {
            return 1;
        }

        @Override
        public R apply(EntryView.ReadWriteEntryView<K, V> view) {
            return this.f.apply(this.valueDataConversion.fromStorage(this.argument), view);
        }
    }

    static class Write<K, V>
    extends BaseMutation<K, V, Void> {
        static final byte TYPE = 2;
        private final Consumer<EntryView.WriteEntryView<K, V>> f;

        public Write(DataConversion keyDataConversion, DataConversion valueDataConversion, Consumer<EntryView.WriteEntryView<K, V>> f) {
            super(keyDataConversion, valueDataConversion);
            this.f = f;
        }

        @Override
        public byte type() {
            return 2;
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<K, V> view) {
            this.f.accept(view);
            return null;
        }
    }

    static class WriteWithValue<K, V, T>
    extends BaseMutation<K, V, Void> {
        static final byte TYPE = 3;
        private final Object argument;
        private final BiConsumer<T, EntryView.WriteEntryView<K, V>> f;

        public WriteWithValue(DataConversion keyDataConversion, DataConversion valueDataConversion, Object argument, BiConsumer<T, EntryView.WriteEntryView<K, V>> f) {
            super(keyDataConversion, valueDataConversion);
            this.argument = argument;
            this.f = f;
        }

        @Override
        public byte type() {
            return 3;
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<K, V> view) {
            this.f.accept(this.valueDataConversion.fromStorage(this.argument), view);
            return null;
        }
    }
}

