/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.CacheContainerConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxConfigurationBuilder;
import org.infinispan.configuration.global.GlobalMetricsConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.GlobalTracingConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.ThreadsConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;

public class CacheContainerConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<CacheContainerConfiguration> {
    private final AttributeSet attributes = CacheContainerConfiguration.attributeDefinitionSet();
    private final GlobalMetricsConfigurationBuilder metrics;
    private final GlobalTracingConfigurationBuilder tracing;
    private final GlobalJmxConfigurationBuilder jmx;
    private final GlobalStateConfigurationBuilder globalState;
    private final TransportConfigurationBuilder transport;
    private final GlobalSecurityConfigurationBuilder security;
    private final SerializationConfigurationBuilder serialization;
    private final ShutdownConfigurationBuilder shutdown;
    private final ThreadsConfigurationBuilder threads;

    CacheContainerConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.metrics = new GlobalMetricsConfigurationBuilder(globalConfig);
        this.tracing = new GlobalTracingConfigurationBuilder(globalConfig);
        this.jmx = new GlobalJmxConfigurationBuilder(globalConfig);
        this.globalState = new GlobalStateConfigurationBuilder(globalConfig);
        this.threads = new ThreadsConfigurationBuilder(globalConfig);
        this.transport = new TransportConfigurationBuilder(globalConfig, this.threads);
        this.security = new GlobalSecurityConfigurationBuilder(globalConfig);
        this.serialization = new SerializationConfigurationBuilder(globalConfig);
        this.shutdown = new ShutdownConfigurationBuilder(globalConfig);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public CacheContainerConfigurationBuilder clusteredDefault() {
        this.transport().defaultTransport().clearProperties();
        return this;
    }

    public CacheContainerConfigurationBuilder nonClusteredDefault() {
        this.transport().transport(null).clearProperties();
        return this;
    }

    public static GlobalConfigurationBuilder defaultClusteredBuilder() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.transport().defaultTransport();
        return builder;
    }

    public String defaultCacheName() {
        return (String)this.attributes.attribute(CacheContainerConfiguration.DEFAULT_CACHE).get();
    }

    @Override
    public GlobalMetricsConfigurationBuilder metrics() {
        return this.metrics;
    }

    @Override
    public GlobalTracingConfigurationBuilder tracing() {
        return this.tracing;
    }

    @Override
    public GlobalJmxConfigurationBuilder jmx() {
        return this.jmx;
    }

    @Override
    public GlobalStateConfigurationBuilder globalState() {
        return this.globalState;
    }

    @Override
    public TransportConfigurationBuilder transport() {
        return this.transport;
    }

    public ThreadsConfigurationBuilder threads() {
        return this.threads;
    }

    @Override
    public ThreadPoolConfigurationBuilder asyncThreadPool() {
        return this.threads.asyncThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder expirationThreadPool() {
        return this.threads.expirationThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder persistenceThreadPool() {
        return this.threads.persistenceThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder listenerThreadPool() {
        return this.threads.listenerThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder nonBlockingThreadPool() {
        return this.threads.nonBlockingThreadPool();
    }

    @Override
    public ThreadPoolConfigurationBuilder blockingThreadPool() {
        return this.threads.blockingThreadPool();
    }

    @Override
    public GlobalSecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public SerializationConfigurationBuilder serialization() {
        return this.serialization;
    }

    @Override
    public ShutdownConfigurationBuilder shutdown() {
        return this.shutdown;
    }

    public CacheContainerConfigurationBuilder defaultCache(String defaultCacheName) {
        this.attributes.attribute(CacheContainerConfiguration.DEFAULT_CACHE).set((Object)defaultCacheName);
        return this;
    }

    public CacheContainerConfigurationBuilder name(String cacheManagerName) {
        this.attributes.attribute(CacheContainerConfiguration.NAME).set((Object)cacheManagerName);
        return this;
    }

    public String name() {
        return (String)this.attributes.attribute(CacheContainerConfiguration.NAME).get();
    }

    public CacheContainerConfigurationBuilder statistics(boolean statistics) {
        this.attributes.attribute(CacheContainerConfiguration.STATISTICS).set((Object)statistics);
        return this;
    }

    @Deprecated(forRemoval=true, since="10.1")
    public CacheContainerConfigurationBuilder statistics(Boolean statistics) {
        return this.statistics((boolean)statistics);
    }

    public boolean statistics() {
        return (Boolean)this.attributes.attribute(CacheContainerConfiguration.STATISTICS).get();
    }

    CacheContainerConfigurationBuilder zeroCapacityNode(boolean zeroCapacityNode) {
        this.attributes.attribute(CacheContainerConfiguration.ZERO_CAPACITY_NODE).set((Object)zeroCapacityNode);
        return this;
    }

    public CacheContainerConfigurationBuilder asyncExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.ASYNC_EXECUTOR).set((Object)name);
        return this;
    }

    CacheContainerConfigurationBuilder listenerExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.LISTENER_EXECUTOR).set((Object)name);
        return this;
    }

    CacheContainerConfigurationBuilder expirationExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.EXPIRATION_EXECUTOR).set((Object)name);
        return this;
    }

    public CacheContainerConfigurationBuilder persistenceExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.PERSISTENCE_EXECUTOR).set((Object)name);
        return this;
    }

    @Deprecated(forRemoval=true, since="10.1")
    public CacheContainerConfigurationBuilder stateTransferExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.STATE_TRANSFER_EXECUTOR).set((Object)name);
        return this;
    }

    public CacheContainerConfigurationBuilder nonBlockingExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.NON_BLOCKING_EXECUTOR).set((Object)name);
        return this;
    }

    public CacheContainerConfigurationBuilder blockingExecutor(String name) {
        this.attributes.attribute(CacheContainerConfiguration.BLOCKING_EXECUTOR).set((Object)name);
        return this;
    }

    public void validate() {
        ArrayList<RuntimeException> validationExceptions = new ArrayList<RuntimeException>();
        try {
            this.attributes.validate();
        }
        catch (RuntimeException e2) {
            validationExceptions.add(e2);
        }
        Arrays.asList(this.metrics, this.tracing, this.jmx, this.globalState, this.transport, this.security, this.serialization, this.shutdown, this.threads).forEach(c -> {
            try {
                ((Builder)c).validate();
            }
            catch (RuntimeException e) {
                validationExceptions.add(e);
            }
        });
        CacheConfigurationException.fromMultipleRuntimeExceptions(validationExceptions).ifPresent(e -> {
            throw e;
        });
    }

    public CacheContainerConfiguration create() {
        Attribute attribute = this.attributes.attribute(CacheContainerConfiguration.NAME);
        if (!attribute.isModified()) {
            this.name((String)attribute.getAttributeDefinition().getDefaultValue());
        }
        return new CacheContainerConfiguration(this.attributes.protect(), this.globalState.create(), this.jmx.create(), this.metrics.create(), this.security.create(), this.serialization.create(), this.shutdown.create(), this.threads.create(), this.tracing.create(), this.transport.create(), this.getGlobalConfig().getFeatures());
    }

    public Builder<?> read(CacheContainerConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.globalState.read(template.globalState(), combine);
        this.metrics.read(template.metrics(), combine);
        this.jmx.read(template.jmx(), combine);
        this.transport.read(template.transport(), combine);
        this.security.read(template.security(), combine);
        this.serialization.read(template.serialization(), combine);
        this.shutdown.read(template.shutdown(), combine);
        this.threads.read(template.threads(), combine);
        this.security.read(template.security(), combine);
        return this;
    }
}

