/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.SimpleFunctionalMap;
import org.infinispan.functional.impl.SimpleWriteNotifierHelper;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.security.actions.SecurityActions;

@Experimental
public class SimpleWriteOnlyMapImpl<K, V>
extends WriteOnlyMapImpl<K, V>
implements SimpleFunctionalMap<K, V> {
    private final CacheNotifier<K, V> notifier;

    protected SimpleWriteOnlyMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(params, functionalMap);
        this.notifier = SecurityActions.getCacheComponentRegistry(functionalMap.cache).getComponent(CacheNotifier.class);
    }

    public static <K, V> FunctionalMap.WriteOnlyMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return SimpleWriteOnlyMapImpl.create(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.WriteOnlyMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new SimpleWriteOnlyMapImpl<K, V>(params, functionalMap);
    }

    @Override
    public CompletableFuture<Void> eval(K key, Consumer<EntryView.WriteEntryView<K, V>> f) {
        return this.eval(key, null, (ignore, e) -> f.accept((EntryView.WriteEntryView)e));
    }

    @Override
    public <T> CompletableFuture<Void> eval(K key, T argument, BiConsumer<T, EntryView.WriteEntryView<K, V>> f) {
        K storageKey = this.toStorageKey(key);
        ByRef holder = new ByRef(null);
        this.fmap.cache.getDataContainer().compute(storageKey, (ignore, entry, factory) -> {
            MVCCEntry e = this.readCacheEntry(storageKey, entry);
            f.accept(argument, EntryViews.writeOnly(e, this.fmap.cache.getValueDataConversion()));
            if (!e.isChanged()) {
                return entry;
            }
            SimpleWriteNotifierHelper.EntryHolder eh = entry == null ? SimpleWriteNotifierHelper.createWriteOnly(null, e) : SimpleWriteNotifierHelper.createWriteOnly(factory.copy(entry), e);
            holder.set(eh);
            SimpleWriteNotifierHelper.handleNotification(this.notifier, this.fmap.notifier, key, eh, true);
            if (e.isRemoved()) {
                return null;
            }
            return entry == null ? factory.create(e) : factory.update(entry, e.getValue(), e.getMetadata());
        });
        SimpleWriteNotifierHelper.handleNotification(this.notifier, this.fmap.notifier, key, (SimpleWriteNotifierHelper.EntryHolder)holder.get(), false);
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletableFuture<Void> evalMany(Set<? extends K> keys, Consumer<EntryView.WriteEntryView<K, V>> f) {
        for (K key : keys) {
            this.toLocalExecution(this.eval(key, f));
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public <T> CompletableFuture<Void> evalMany(Map<? extends K, ? extends T> arguments, BiConsumer<T, EntryView.WriteEntryView<K, V>> f) {
        for (Map.Entry<K, T> entry : arguments.entrySet()) {
            this.toLocalExecution(this.eval(entry.getKey(), entry.getValue(), f));
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletableFuture<Void> evalAll(Consumer<EntryView.WriteEntryView<K, V>> f) {
        return this.evalMany((Set<? extends K>)((Object)this.fmap.cache.keySet()), f);
    }
}

