/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.ExceptionSyncInvocationStage;
import org.infinispan.interceptors.InvocationCallback;
import org.infinispan.interceptors.InvocationExceptionFunction;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.InvocationSuccessFunction;

public class SyncInvocationStage
extends InvocationStage {
    static SyncInvocationStage COMPLETED_NULL_STAGE = new SyncInvocationStage();
    static SyncInvocationStage COMPLETED_TRUE_STAGE = new SyncInvocationStage(Boolean.TRUE);
    static SyncInvocationStage COMPLETED_FALSE_STAGE = new SyncInvocationStage(Boolean.FALSE);
    private final Object rv;

    public SyncInvocationStage(Object rv) {
        this.rv = rv;
    }

    public SyncInvocationStage() {
        this.rv = null;
    }

    @Override
    public Object get() throws Throwable {
        return this.rv;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return CompletableFuture.completedFuture(this.rv);
    }

    @Override
    public <C extends VisitableCommand> Object thenApply(InvocationContext ctx, C command, InvocationSuccessFunction<C> function) {
        try {
            return function.apply(ctx, command, this.rv);
        }
        catch (Throwable throwable) {
            return new ExceptionSyncInvocationStage(throwable);
        }
    }

    @Override
    public <C extends VisitableCommand> Object thenAccept(InvocationContext ctx, C command, InvocationSuccessAction<C> action) {
        return this.thenAcceptMakeStage(ctx, command, action);
    }

    @Override
    public <C extends VisitableCommand> Object andExceptionally(InvocationContext ctx, C command, InvocationExceptionFunction<C> function) {
        return this;
    }

    @Override
    public <C extends VisitableCommand> Object andFinally(InvocationContext ctx, C command, InvocationFinallyAction<C> action) {
        return this.andFinallyMakeStage(ctx, command, action);
    }

    @Override
    public <C extends VisitableCommand> Object andHandle(InvocationContext ctx, C command, InvocationFinallyFunction<C> function) {
        try {
            return function.apply(ctx, command, this.rv, null);
        }
        catch (Throwable throwable) {
            return new ExceptionSyncInvocationStage(throwable);
        }
    }

    @Override
    public <C extends VisitableCommand> Object addCallback(InvocationContext ctx, C command, InvocationCallback<C> function) {
        try {
            return function.apply(ctx, command, this.rv, null);
        }
        catch (Throwable throwable) {
            return new ExceptionSyncInvocationStage(throwable);
        }
    }

    @Override
    public <C extends VisitableCommand> InvocationStage thenApplyMakeStage(InvocationContext ctx, C command, InvocationSuccessFunction<C> function) {
        try {
            return SyncInvocationStage.makeStage(function.apply(ctx, command, this.rv));
        }
        catch (Throwable throwable) {
            return new ExceptionSyncInvocationStage(throwable);
        }
    }

    @Override
    public <C extends VisitableCommand> InvocationStage thenAcceptMakeStage(InvocationContext ctx, C command, InvocationSuccessAction<C> action) {
        try {
            action.accept(ctx, command, this.rv);
            return this;
        }
        catch (Throwable throwable) {
            return new ExceptionSyncInvocationStage(throwable);
        }
    }

    @Override
    public <C extends VisitableCommand> InvocationStage andExceptionallyMakeStage(InvocationContext ctx, C command, InvocationExceptionFunction<C> function) {
        return this;
    }

    @Override
    public <C extends VisitableCommand> InvocationStage andFinallyMakeStage(InvocationContext ctx, C command, InvocationFinallyAction<C> action) {
        try {
            action.accept(ctx, command, this.rv, null);
            return this;
        }
        catch (Throwable throwable) {
            return new ExceptionSyncInvocationStage(throwable);
        }
    }

    @Override
    public <C extends VisitableCommand> InvocationStage andHandleMakeStage(InvocationContext ctx, C command, InvocationFinallyFunction<C> function) {
        try {
            return SyncInvocationStage.makeStage(function.apply(ctx, command, this.rv, null));
        }
        catch (Throwable throwable) {
            return new ExceptionSyncInvocationStage(throwable);
        }
    }

    @Override
    public Object thenReturn(InvocationContext ctx, VisitableCommand command, Object returnValue) {
        return returnValue;
    }

    public String toString() {
        return "SyncInvocationStage(" + String.valueOf(this.rv) + ")";
    }
}

