/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.GLOBAL)
public class EncoderRegistryImpl
implements EncoderRegistry {
    private final Map<Short, Encoder> encoderMap = new ConcurrentHashMap<Short, Encoder>();
    private final Map<Byte, Wrapper> wrapperMap = new ConcurrentHashMap<Byte, Wrapper>();
    private final List<Transcoder> transcoders = Collections.synchronizedList(new ArrayList());
    private final Map<MediaType, Map<MediaType, Transcoder>> transcoderCache = new ConcurrentHashMap<MediaType, Map<MediaType, Transcoder>>();

    @Override
    public void registerEncoder(Encoder encoder) {
        if (encoder == null) {
            throw new NullPointerException("Encoder cannot be null");
        }
        short id = encoder.id();
        if (this.encoderMap.containsKey(id)) {
            throw Log.CONTAINER.duplicateIdEncoder(id);
        }
        this.encoderMap.put(id, encoder);
    }

    @Override
    public void registerWrapper(Wrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("Wrapper cannot be null");
        }
        byte id = wrapper.id();
        if (this.wrapperMap.containsKey(id)) {
            throw Log.CONTAINER.duplicateIdWrapper(id);
        }
        this.wrapperMap.put(id, wrapper);
    }

    @Override
    public void registerTranscoder(Transcoder transcoder) {
        this.transcoders.add(transcoder);
    }

    @Override
    public Transcoder getTranscoder(MediaType mediaType, MediaType another) {
        Transcoder transcoder = this.getTranscoderOrNull(mediaType, another);
        if (transcoder == null) {
            throw Log.CONTAINER.cannotFindTranscoder(mediaType, another);
        }
        return transcoder;
    }

    private Transcoder getTranscoderOrNull(MediaType mediaType, MediaType another) {
        return this.transcoderCache.computeIfAbsent(mediaType, mt -> new ConcurrentHashMap(4)).computeIfAbsent(another, mt -> this.transcoders.stream().filter(t -> t.supportsConversion(mediaType, another)).findFirst().orElse(null));
    }

    @Override
    public <T extends Transcoder> T getTranscoder(Class<T> clazz) {
        Transcoder transcoder = this.transcoders.stream().filter(p -> p.getClass() == clazz).findAny().orElse(null);
        return (T)((Transcoder)clazz.cast(transcoder));
    }

    @Override
    public boolean isConversionSupported(MediaType from, MediaType to) {
        if (from == null || to == null) {
            throw new NullPointerException("MediaType must not be null!");
        }
        return from.match(to) || this.getTranscoderOrNull(from, to) != null;
    }

    @Override
    public Encoder getEncoder(Class<? extends Encoder> clazz, short encoderId) {
        if (clazz == null && encoderId == 0) {
            throw new NullPointerException("Encoder class or identifier must be provided!");
        }
        if (encoderId != 0) {
            Encoder encoder = this.encoderMap.get(encoderId);
            if (encoder == null) {
                throw Log.CONTAINER.encoderIdNotFound(encoderId);
            }
            return encoder;
        }
        for (Encoder e : this.encoderMap.values()) {
            if (e.getClass() != clazz) continue;
            return e;
        }
        throw Log.CONTAINER.encoderClassNotFound(clazz);
    }

    @Override
    public boolean isRegistered(Class<? extends Encoder> encoderClass) {
        return this.encoderMap.values().stream().anyMatch(e -> e.getClass() == encoderClass);
    }

    @Override
    public Wrapper getWrapper(Class<? extends Wrapper> clazz, byte wrapperId) {
        Wrapper wrapper;
        if (clazz == null && wrapperId == 0) {
            return null;
        }
        if (wrapperId != 0) {
            wrapper = this.wrapperMap.get(wrapperId);
            if (wrapper == null) {
                throw Log.CONTAINER.wrapperIdNotFound(wrapperId);
            }
        } else {
            wrapper = this.wrapperMap.values().stream().filter(e -> e.getClass() == clazz).findAny().orElse(null);
            if (wrapper == null) {
                throw Log.CONTAINER.wrapperClassNotFound(clazz);
            }
        }
        return wrapper;
    }

    @Override
    public Object convert(Object o, MediaType from, MediaType to) {
        if (o == null) {
            return null;
        }
        Transcoder transcoder = this.getTranscoder(from, to);
        return transcoder.transcode(o, from, to);
    }
}

