/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.Collections;
import java.util.Map;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.util.logging.Log;

public class SingletonMapResponseCollector
extends ValidSingleResponseCollector<Map<Address, Response>> {
    private static final SingletonMapResponseCollector VALID_ONLY = new SingletonMapResponseCollector(false);
    private static final SingletonMapResponseCollector IGNORE_LEAVERS = new SingletonMapResponseCollector(true);
    private final boolean ignoreLeavers;

    public static SingletonMapResponseCollector validOnly() {
        return VALID_ONLY;
    }

    public static SingletonMapResponseCollector ignoreLeavers() {
        return IGNORE_LEAVERS;
    }

    private SingletonMapResponseCollector(boolean ignoreLeavers) {
        this.ignoreLeavers = ignoreLeavers;
    }

    @Override
    protected Map<Address, Response> withValidResponse(Address sender, ValidResponse response) {
        return Collections.singletonMap(sender, response);
    }

    @Override
    protected Map<Address, Response> targetNotFound(Address sender) {
        if (!this.ignoreLeavers) {
            throw Log.CLUSTER.remoteNodeSuspected(sender);
        }
        return Collections.singletonMap(sender, CacheNotFoundResponse.INSTANCE);
    }
}

