/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.irac.IracManagerKeyInfo;
import org.infinispan.xsite.irac.IracManagerKeyState;
import org.infinispan.xsite.irac.IracXSiteBackup;

class IracManagerKeyChangedState
implements IracManagerKeyState {
    private static final AtomicReferenceFieldUpdater<IracManagerKeyChangedState, Status> STATUS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(IracManagerKeyChangedState.class, Status.class, "status");
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    final IracManagerKeyInfo keyInfo;
    private final boolean expiration;
    @GuardedBy(value="backupMissing")
    private final BitSet backupMissing;
    private volatile Status status = Status.READY;

    public IracManagerKeyChangedState(int segment, Object key, Object owner, boolean expiration, int numberOfBackups) {
        this.keyInfo = new IracManagerKeyInfo(segment, key, owner);
        this.expiration = expiration;
        BitSet backupMissing = new BitSet(numberOfBackups);
        backupMissing.set(0, numberOfBackups);
        this.backupMissing = backupMissing;
    }

    @Override
    public IracManagerKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    @Override
    public Object getKey() {
        return this.keyInfo.key;
    }

    @Override
    public Object getOwner() {
        return this.keyInfo.owner;
    }

    @Override
    public int getSegment() {
        return this.keyInfo.segment;
    }

    @Override
    public boolean isExpiration() {
        return this.expiration;
    }

    @Override
    public boolean isStateTransfer() {
        return false;
    }

    @Override
    public boolean canSend() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] State.setSending for key %s (status=%s)", Util.toStr((Object)this.getKey()), (Object)this.status);
        }
        return STATUS_UPDATER.compareAndSet(this, Status.READY, Status.SENDING);
    }

    @Override
    public void retry() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] State.setRetry for key %s (status=%s)", Util.toStr((Object)this.getKey()), (Object)this.status);
        }
        STATUS_UPDATER.compareAndSet(this, Status.SENDING, Status.READY);
    }

    @Override
    public boolean isDone() {
        return STATUS_UPDATER.get(this) == Status.DONE;
    }

    @Override
    public void discard() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] State.setDiscard for key %s (status=%s)", Util.toStr((Object)this.getKey()), (Object)this.status);
        }
        STATUS_UPDATER.lazySet(this, Status.DONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void successFor(IracXSiteBackup site) {
        BitSet bitSet = this.backupMissing;
        synchronized (bitSet) {
            this.backupMissing.clear(site.siteIndex());
            if (this.backupMissing.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.tracef("[IRAC] State.setCompleted for key %s (status=%s)", Util.toStr((Object)this.getKey()), (Object)this.status);
                }
                STATUS_UPDATER.set(this, Status.DONE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasSuccessful(IracXSiteBackup site) {
        BitSet bitSet = this.backupMissing;
        synchronized (bitSet) {
            return !this.backupMissing.get(site.siteIndex());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{segment=" + this.keyInfo.segment + ", key=" + Util.toStr((Object)this.keyInfo.key) + ", owner=" + String.valueOf(this.keyInfo.owner) + ", expiration=" + this.expiration + ", isStateTransfer=" + this.isStateTransfer() + ", status=" + String.valueOf((Object)this.status) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        IracManagerKeyChangedState that = (IracManagerKeyChangedState)o;
        if (this.getSegment() != that.getSegment()) {
            return false;
        }
        if (!this.getKey().equals(that.getKey())) {
            return false;
        }
        return this.getOwner().equals(that.getOwner());
    }

    public int hashCode() {
        int result = this.getSegment();
        result = 31 * result + this.getKey().hashCode();
        result = 31 * result + this.getOwner().hashCode();
        return result;
    }

    static enum Status {
        READY,
        SENDING,
        DONE;

    }
}

