/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.hibernate.orm.deployment.ClassNames;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public class GraalVMFeatures {
    @BuildStep
    NativeImageFeatureBuildItem staticNativeImageFeature() {
        return new NativeImageFeatureBuildItem("org.hibernate.graalvm.internal.GraalVMStaticFeature");
    }

    @BuildStep
    ReflectiveClassBuildItem registerGeneratorAndOptimizerClassesForReflections() {
        return ReflectiveClassBuildItem.builder((String[])((String[])Stream.concat(ClassNames.GENERATORS.stream(), ClassNames.OPTIMIZERS.stream()).map(DotName::toString).toArray(String[]::new))).reason(ClassNames.GRAAL_VM_FEATURES.toString()).build();
    }

    @BuildStep
    ReflectiveClassBuildItem registerJdbcArrayTypesForReflection() {
        return ReflectiveClassBuildItem.builder((String[])((String[])ClassNames.JDBC_JAVA_TYPES.stream().map(d -> d.toString() + "[]").toArray(String[]::new))).reason(ClassNames.GRAAL_VM_FEATURES.toString()).build();
    }

    @BuildStep
    ReflectiveClassBuildItem registerNamingStrategiesForReflections() {
        return ReflectiveClassBuildItem.builder((String[])((String[])ClassNames.NAMING_STRATEGIES.stream().map(DotName::toString).toArray(String[]::new))).reason(ClassNames.GRAAL_VM_FEATURES.toString()).build();
    }
}

