/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DisconnectRemoteStoreTask
implements Function<EmbeddedCacheManager, Void> {
    private static final Log log = (Log)LogFactory.getLog(DisconnectRemoteStoreTask.class, Log.class);
    private final String cacheName;

    public DisconnectRemoteStoreTask(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public Void apply(EmbeddedCacheManager embeddedCacheManager) {
        PersistenceManager persistenceManager = (PersistenceManager)ComponentRegistry.componentOf((Cache)embeddedCacheManager.getCache(this.cacheName), PersistenceManager.class);
        try {
            log.debugf("Disconnecting source for cache {}", this.cacheName);
            return (Void)CompletionStages.join((CompletionStage)persistenceManager.disableStore(RemoteStore.class.getName()));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<DisconnectRemoteStoreTask> {
        public Set<Class<? extends DisconnectRemoteStoreTask>> getTypeClasses() {
            return Collections.singleton(DisconnectRemoteStoreTask.class);
        }

        public void writeObject(ObjectOutput output, DisconnectRemoteStoreTask task) throws IOException {
            output.writeObject(task.cacheName);
        }

        public DisconnectRemoteStoreTask readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String cacheName = (String)input.readObject();
            return new DisconnectRemoteStoreTask(cacheName);
        }
    }
}

