/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import java.io.IOException;
import org.keycloak.common.crypto.CryptoIntegration;

public enum ECDSAAlgorithm {
    ES256(64),
    ES384(96),
    ES512(132);

    private final int signatureLength;

    private ECDSAAlgorithm(int signatureLength) {
        this.signatureLength = signatureLength;
    }

    public int getSignatureLength() {
        return this.signatureLength;
    }

    public static int getSignatureLength(String alg) {
        return ECDSAAlgorithm.valueOf(alg).getSignatureLength();
    }

    public static byte[] concatenatedRSToASN1DER(byte[] signature, int signLength) throws IOException {
        return CryptoIntegration.getProvider().getEcdsaCryptoProvider().concatenatedRSToASN1DER(signature, signLength);
    }

    public static byte[] asn1derToConcatenatedRS(byte[] derEncodedSignatureValue, int signLength) throws IOException {
        return CryptoIntegration.getProvider().getEcdsaCryptoProvider().asn1derToConcatenatedRS(derEncodedSignatureValue, signLength);
    }
}

