/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.keycloak.sdjwt.Disclosable;
import org.keycloak.sdjwt.SdJwtClaim;
import org.keycloak.sdjwt.SdJwtClaimName;
import org.keycloak.sdjwt.SdJwtSalt;
import org.keycloak.sdjwt.SdJwtUtils;

public class UndisclosedClaim
extends Disclosable
implements SdJwtClaim {
    private final SdJwtClaimName claimName;
    private final JsonNode claimValue;

    private UndisclosedClaim(SdJwtClaimName claimName, SdJwtSalt salt, JsonNode claimValue) {
        super(salt);
        this.claimName = claimName;
        this.claimValue = claimValue;
    }

    @Override
    Object[] toArray() {
        return new Object[]{this.getSaltAsString(), this.getClaimNameAsString(), this.claimValue};
    }

    @Override
    public SdJwtClaimName getClaimName() {
        return this.claimName;
    }

    @Override
    public String getClaimNameAsString() {
        return this.claimName.toString();
    }

    @Override
    public JsonNode getVisibleClaimValue(String hashAlgo) {
        throw new UnsupportedOperationException("Unimplemented method 'getVisibleClaimValue'");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<String> getDisclosureStrings() {
        return Collections.singletonList(this.getDisclosureString());
    }

    public static class Builder {
        private SdJwtClaimName claimName;
        private SdJwtSalt salt;
        private JsonNode claimValue;

        public Builder withClaimName(String claimName) {
            this.claimName = new SdJwtClaimName(claimName);
            return this;
        }

        public Builder withSalt(SdJwtSalt salt) {
            this.salt = salt;
            return this;
        }

        public Builder withClaimValue(JsonNode claimValue) {
            this.claimValue = claimValue;
            return this;
        }

        public UndisclosedClaim build() {
            this.claimName = Objects.requireNonNull(this.claimName, "claimName must not be null");
            this.claimValue = Objects.requireNonNull(this.claimValue, "claimValue must not be null");
            this.salt = this.salt == null ? new SdJwtSalt(SdJwtUtils.randomSalt()) : this.salt;
            return new UndisclosedClaim(this.claimName, this.salt, this.claimValue);
        }
    }
}

