/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.conn;

import java.sql.Connection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import liquibase.Scope;
import liquibase.ScopeManager;
import liquibase.ThreadLocalScopeManager;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.ui.LoggerUIService;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.database.Database;
import org.keycloak.connections.jpa.updater.liquibase.conn.KeycloakLiquibase;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProvider;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultLiquibaseConnectionProvider
implements LiquibaseConnectionProviderFactory,
LiquibaseConnectionProvider {
    private static final Logger logger = Logger.getLogger(DefaultLiquibaseConnectionProvider.class);
    public static final String INDEX_CREATION_THRESHOLD_PARAM = "keycloak.indexCreationThreshold";
    private int indexCreationThreshold;
    private Class<? extends Database> liquibaseDatabaseClazz;
    private static final AtomicBoolean INITIALIZATION = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiquibaseConnectionProvider create(KeycloakSession session) {
        if (!INITIALIZATION.get()) {
            AtomicBoolean atomicBoolean = INITIALIZATION;
            synchronized (atomicBoolean) {
                if (!INITIALIZATION.get()) {
                    this.baseLiquibaseInitialization();
                    INITIALIZATION.set(true);
                }
            }
        }
        return this;
    }

    protected void baseLiquibaseInitialization() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Scope.setScopeManager((ScopeManager)new ThreadLocalScopeManager());
            Scope.getCurrentScope();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        HashMap<String, Object> scopeValues = new HashMap<String, Object>();
        scopeValues.put(Scope.Attr.resourceAccessor.name(), new ClassLoaderResourceAccessor(this.getClass().getClassLoader()));
        scopeValues.put(Scope.Attr.classLoader.name(), this.getClass().getClassLoader());
        scopeValues.put(Scope.Attr.ui.name(), new LoggerUIService());
        try {
            Scope.enter(scopeValues);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Liquibase: " + e.getMessage(), e);
        }
    }

    public void init(Config.Scope config) {
        this.indexCreationThreshold = config.getInt("indexCreationThreshold", Integer.valueOf(300000));
        logger.debugf("indexCreationThreshold is %d", this.indexCreationThreshold);
        String dbAlias = config.root().get(DatabaseOptions.DB.getKey(), "dev-file");
        logger.debugf("dbAlias is %s", (Object)dbAlias);
        String liquibaseType = ((Database.Vendor)org.keycloak.config.database.Database.getVendor((String)dbAlias).orElseThrow()).getLiquibaseType();
        logger.debugf("liquibaseType is %s", (Object)liquibaseType);
        try {
            this.liquibaseDatabaseClazz = Class.forName(liquibaseType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load Liquibase Database class: " + liquibaseType, e);
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    @Override
    public KeycloakLiquibase getLiquibase(Connection connection, String defaultSchema) throws LiquibaseException {
        Database database = this.getLiquibaseDatabase(connection);
        if (defaultSchema != null) {
            database.setDefaultSchemaName(defaultSchema);
        }
        String changelog = "META-INF/jpa-changelog-master.xml";
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
        logger.debugf("Using changelog file %s and changelogTableName %s", (Object)changelog, (Object)database.getDatabaseChangeLogTableName());
        ((AbstractJdbcDatabase)database).set(INDEX_CREATION_THRESHOLD_PARAM, (Object)this.indexCreationThreshold);
        return new KeycloakLiquibase(changelog, (ResourceAccessor)resourceAccessor, database);
    }

    @Override
    public KeycloakLiquibase getLiquibaseForCustomUpdate(Connection connection, String defaultSchema, String changelogLocation, ClassLoader classloader, String changelogTableName) throws LiquibaseException {
        Database database = this.getLiquibaseDatabase(connection);
        if (defaultSchema != null) {
            database.setDefaultSchemaName(defaultSchema);
        }
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(classloader);
        database.setDatabaseChangeLogTableName(changelogTableName);
        logger.debugf("Using changelog file %s and changelogTableName %s", (Object)changelogLocation, (Object)database.getDatabaseChangeLogTableName());
        return new KeycloakLiquibase(changelogLocation, (ResourceAccessor)resourceAccessor, database);
    }

    private Database getLiquibaseDatabase(Connection connection) {
        Database liquibaseDatabase;
        try {
            liquibaseDatabase = this.liquibaseDatabaseClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + this.liquibaseDatabaseClazz.getName());
        }
        JdbcConnection liquibaseConnection = new JdbcConnection(connection);
        try {
            logger.debugf("DB Product Name: %s", (Object)liquibaseConnection.getDatabaseProductName());
        }
        catch (LiquibaseException e) {
            logger.debug((Object)"Failed to detect DB Product Name", (Throwable)e);
        }
        liquibaseDatabase.setConnection((DatabaseConnection)liquibaseConnection);
        return liquibaseDatabase;
    }
}

