/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.session.PersistentAuthenticatedClientSessionAdapter;

class ClientSessionLoader
implements Consumer<Map<String, AuthenticatedClientSessionModel>> {
    private boolean loaded = false;
    private final Supplier<Stream<PersistentAuthenticatedClientSessionAdapter>> supplier;

    ClientSessionLoader(Supplier<Stream<PersistentAuthenticatedClientSessionAdapter>> supplier) {
        assert (supplier != null);
        this.supplier = supplier;
    }

    @Override
    public void accept(Map<String, AuthenticatedClientSessionModel> clientSessions) {
        if (this.loaded) {
            return;
        }
        this.supplier.get().forEach(m -> clientSessions.put(m.getClient().getId(), (AuthenticatedClientSessionModel)m));
        this.loaded = true;
    }
}

