/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import java.util.List;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowInvalidStateException;

public class GroupMembershipWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final List<String> expectedGroups;
    private final KeycloakSession session;

    public GroupMembershipWorkflowConditionProvider(KeycloakSession session, List<String> expectedGroups) {
        this.session = session;
        this.expectedGroups = expectedGroups;
    }

    public boolean evaluate(WorkflowEvent event) {
        if (!ResourceType.USERS.equals((Object)event.getResourceType())) {
            return false;
        }
        this.validate();
        String userId = event.getResourceId();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, userId);
        for (String expectedGroup : this.expectedGroups) {
            GroupModel group = this.session.groups().getGroupById(realm, expectedGroup);
            if (!user.isMemberOf(group)) continue;
            return true;
        }
        return false;
    }

    public void validate() {
        this.expectedGroups.forEach(id -> {
            if (this.session.groups().getGroupById(this.session.getContext().getRealm(), id) == null) {
                throw new WorkflowInvalidStateException(String.format("Group with id %s does not exist.", id));
            }
        });
    }

    public void close() {
    }
}

