/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.hibernate.models.UnhandledMethodException;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.MutableAnnotationDescriptor;

public class AnnotationProxy<A extends Annotation>
implements InvocationHandler {
    private final AnnotationDescriptor<A> annotationDescriptor;
    private final Map<String, Object> valueMap;

    public AnnotationProxy(AnnotationDescriptor<A> annotationDescriptor, Map<String, Object> valueMap) {
        this.annotationDescriptor = annotationDescriptor;
        this.valueMap = valueMap;
    }

    public void setValue(String name, Object value) {
        this.valueMap.put(name, value);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        switch (method.getName()) {
            case "annotationType": {
                return this.annotationDescriptor.getAnnotationType();
            }
            case "toString": {
                return "AnnotationProxy(" + this.annotationDescriptor.getAnnotationType().getName() + ")";
            }
            case "equals": {
                return proxy == this;
            }
        }
        if (method.getParameterCount() == 0) {
            AttributeDescriptor attributeDescriptor = this.annotationDescriptor.getAttribute(method.getName());
            return attributeDescriptor.getTypeDescriptor().unwrap(this.valueMap.get(method.getName()));
        }
        if (this.isSetValueMethod(method)) {
            assert (method.getParameterCount() == 2);
            this.valueMap.put((String)args[0], args[1]);
        }
        if (method.getParameterCount() == 1) {
            this.valueMap.put(method.getName(), args[0]);
            return null;
        }
        throw new UnhandledMethodException("Unhandled method - " + method.toGenericString());
    }

    private boolean isSetValueMethod(Method method) {
        if (!"setValue".equals(method.getName()) || method.getParameterCount() != 2) {
            return false;
        }
        return String.class.equals(method.getParameterTypes()[0]);
    }

    public static <A extends Annotation> A makeProxy(AnnotationDescriptor<A> descriptor, Map<String, Object> valueMap) {
        AnnotationProxy<A> handler = new AnnotationProxy<A>(descriptor, valueMap);
        Class[] interfaces = descriptor instanceof MutableAnnotationDescriptor ? new Class[]{descriptor.getAnnotationType(), ((MutableAnnotationDescriptor)descriptor).getMutableAnnotationType()} : new Class[]{descriptor.getAnnotationType()};
        return (A)((Annotation)Proxy.newProxyInstance(AnnotationProxy.class.getClassLoader(), interfaces, handler));
    }
}

