/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.List;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class ParameterizedTypeDetailsImpl
implements ParameterizedTypeDetails {
    private final ClassDetails genericClassDetails;
    private final List<TypeDetails> arguments;
    private final TypeVariableScope owner;

    public ParameterizedTypeDetailsImpl(ClassDetails genericClassDetails, List<TypeDetails> arguments, TypeVariableScope owner) {
        this.genericClassDetails = genericClassDetails;
        this.arguments = arguments;
        this.owner = owner;
    }

    @Override
    public ClassDetails getRawClassDetails() {
        return this.genericClassDetails;
    }

    @Override
    public List<TypeDetails> getArguments() {
        return this.arguments;
    }

    @Override
    public TypeVariableScope getOwner() {
        return this.owner;
    }

    @Override
    public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        return TypeDetailsHelper.resolveTypeVariableFromParameterizedType(this, typeVariable);
    }
}

