/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.spi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.AnnotationTargetHelper;
import org.hibernate.models.internal.SimpleClassDetails;
import org.hibernate.models.internal.util.IndexedConsumer;
import org.hibernate.models.serial.spi.SerialClassDetails;
import org.hibernate.models.serial.spi.Storable;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableScope;

public interface ClassDetails
extends AnnotationTarget,
TypeVariableScope,
Storable<ClassDetails, SerialClassDetails> {
    public static final ClassDetails OBJECT_CLASS_DETAILS;
    public static final ClassDetails CLASS_CLASS_DETAILS;
    public static final ClassDetails VOID_CLASS_DETAILS;
    public static final ClassDetails VOID_OBJECT_CLASS_DETAILS;

    @Override
    default public AnnotationTarget.Kind getKind() {
        return AnnotationTarget.Kind.CLASS;
    }

    @Override
    public String getName();

    public String getClassName();

    @Override
    default public ClassDetails getContainer(ModelsContext modelsContext) {
        if (this.getClassName() == null || this.getClassName().indexOf(".") <= 0) {
            return null;
        }
        return AnnotationTargetHelper.resolvePackageInfo(this, modelsContext);
    }

    public boolean isResolved();

    public boolean isAbstract();

    public boolean isInterface();

    public boolean isEnum();

    public boolean isRecord();

    public ClassDetails getSuperClass();

    public TypeDetails getGenericSuperType();

    public List<TypeDetails> getImplementedInterfaces();

    public List<TypeVariableDetails> getTypeParameters();

    default public void forEachSuper(ClassDetailsConsumer consumer) {
        for (ClassDetails check = this.getSuperClass(); check != null && check != OBJECT_CLASS_DETAILS; check = check.getSuperClass()) {
            consumer.accept(check);
        }
    }

    default public void forSelfAndEachSuper(ClassDetailsConsumer consumer) {
        consumer.accept(this);
        this.forEachSuper(consumer);
    }

    default public boolean isSuperclass(ClassDetails classDetails) {
        for (ClassDetails check = this.getSuperClass(); check != null && check != OBJECT_CLASS_DETAILS; check = check.getSuperClass()) {
            if (classDetails != check) continue;
            return true;
        }
        return false;
    }

    @Override
    default public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        TypeDetails genericSuperType;
        if (this == typeVariable.getDeclaringType()) {
            return TypeDetailsHelper.findTypeVariableDetails(typeVariable.getIdentifier(), this.getTypeParameters());
        }
        if (this.isSuperclass(typeVariable.getDeclaringType()) && (genericSuperType = this.getGenericSuperType()) != null) {
            return genericSuperType.resolveTypeVariable(typeVariable);
        }
        return null;
    }

    @Override
    default public ClassDetails determineRawClass() {
        return this;
    }

    public boolean isImplementor(Class<?> var1);

    public List<FieldDetails> getFields();

    public void forEachField(IndexedConsumer<FieldDetails> var1);

    default public FieldDetails findField(Predicate<FieldDetails> check) {
        List<FieldDetails> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            FieldDetails fieldDetails = fields.get(i);
            if (!check.test(fieldDetails)) continue;
            return fieldDetails;
        }
        return null;
    }

    default public FieldDetails findFieldByName(String name) {
        if (!1.$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.findField(fieldDetails -> name.equals(fieldDetails.getName()));
    }

    public List<MethodDetails> getMethods();

    public void forEachMethod(IndexedConsumer<MethodDetails> var1);

    public List<RecordComponentDetails> getRecordComponents();

    default public RecordComponentDetails findRecordComponent(Predicate<RecordComponentDetails> check) {
        List<RecordComponentDetails> components = this.getRecordComponents();
        for (int i = 0; i < components.size(); ++i) {
            RecordComponentDetails component = components.get(i);
            if (!check.test(component)) continue;
            return component;
        }
        return null;
    }

    default public RecordComponentDetails findRecordComponentByName(String name) {
        if (!1.$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.findRecordComponent(component -> name.equals(component.getName()));
    }

    public void forEachRecordComponent(IndexedConsumer<RecordComponentDetails> var1);

    default public void forEachMember(Consumer<MemberDetails> consumer) {
        this.forEachField((i, field) -> consumer.accept((MemberDetails)field));
        this.forEachMethod((i, method) -> consumer.accept((MemberDetails)method));
        this.forEachRecordComponent((i, recordComponent) -> consumer.accept((MemberDetails)recordComponent));
    }

    default public void forEachPersistableMember(Consumer<MemberDetails> consumer) {
        this.forEachField((i, field) -> {
            if (field.isPersistable()) {
                consumer.accept((MemberDetails)field);
            }
        });
        this.forEachMethod((i, method) -> {
            if (method.isPersistable()) {
                consumer.accept((MemberDetails)method);
            }
        });
        this.forEachRecordComponent((i, recordComponent) -> {
            if (recordComponent.isPersistable()) {
                consumer.accept((MemberDetails)recordComponent);
            }
        });
    }

    public <X> Class<X> toJavaClass();

    public <X> Class<X> toJavaClass(ClassLoading var1, ModelsContext var2);

    @Override
    default public ClassDetails asClassDetails() {
        return this;
    }

    @Override
    default public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("ClassDetails cannot be cast to AnnotationDescriptor");
    }

    @Override
    default public MemberDetails asMemberDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast to MemberDescriptor");
    }

    @Override
    default public FieldDetails asFieldDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast to FieldDetails");
    }

    @Override
    default public MethodDetails asMethodDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast to MethodDetails");
    }

    @Override
    default public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("ClassDetails cannot be cast to RecordComponentDetails");
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        OBJECT_CLASS_DETAILS = new SimpleClassDetails(Object.class);
        CLASS_CLASS_DETAILS = new SimpleClassDetails(Class.class);
        VOID_CLASS_DETAILS = new SimpleClassDetails(Void.TYPE);
        VOID_OBJECT_CLASS_DETAILS = new SimpleClassDetails(Void.class);
    }

    @FunctionalInterface
    public static interface ClassDetailsConsumer
    extends Consumer<ClassDetails> {
        @Override
        public void accept(ClassDetails var1);
    }
}

