/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.hash;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.credential.hash.PasswordHashProviderFactory;
import org.keycloak.crypto.hash.Argon2Parameters;
import org.keycloak.crypto.hash.Argon2PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class Argon2PasswordHashProviderFactory
implements PasswordHashProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String ID = "argon2";
    public static final String TYPE_KEY = "type";
    public static final String VERSION_KEY = "version";
    public static final String HASH_LENGTH_KEY = "hashLength";
    public static final String MEMORY_KEY = "memory";
    public static final String ITERATIONS_KEY = "iterations";
    public static final String PARALLELISM_KEY = "parallelism";
    public static final String CPU_CORES_KEY = "cpuCores";
    private Semaphore cpuCoreSemaphore;
    private String version;
    private String type;
    private int hashLength;
    private int memory;
    private int iterations;
    private int parallelism;

    public PasswordHashProvider create(KeycloakSession session) {
        return new Argon2PasswordHashProvider(this.version, this.type, this.hashLength, this.memory, this.iterations, this.parallelism, this.cpuCoreSemaphore);
    }

    public void init(Config.Scope config) {
        this.version = config.get(VERSION_KEY, Argon2Parameters.DEFAULT_VERSION);
        this.type = config.get(TYPE_KEY, Argon2Parameters.DEFAULT_TYPE);
        this.hashLength = config.getInt(HASH_LENGTH_KEY, Integer.valueOf(Argon2Parameters.DEFAULT_HASH_LENGTH));
        this.memory = config.getInt(MEMORY_KEY, Integer.valueOf(Argon2Parameters.DEFAULT_MEMORY));
        this.iterations = config.getInt(ITERATIONS_KEY, Integer.valueOf(Argon2Parameters.DEFAULT_ITERATIONS));
        this.parallelism = config.getInt(PARALLELISM_KEY, Integer.valueOf(Argon2Parameters.DEFAULT_PARALLELISM));
        this.cpuCoreSemaphore = new Semaphore(config.getInt(CPU_CORES_KEY, Integer.valueOf(Runtime.getRuntime().availableProcessors())));
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name(VERSION_KEY).type("string").helpText("Version").options(new LinkedList<String>(Argon2Parameters.listVersions())).defaultValue((Object)Argon2Parameters.DEFAULT_VERSION).add();
        builder.property().name(TYPE_KEY).type("string").helpText("Type").options(new LinkedList<String>(Argon2Parameters.listTypes())).defaultValue((Object)Argon2Parameters.DEFAULT_TYPE).add();
        builder.property().name(HASH_LENGTH_KEY).type("int").helpText("Hash length").defaultValue((Object)Argon2Parameters.DEFAULT_HASH_LENGTH).add();
        builder.property().name(MEMORY_KEY).type("int").helpText("Memory size (KB)").defaultValue((Object)Argon2Parameters.DEFAULT_MEMORY).add();
        builder.property().name(ITERATIONS_KEY).type("int").helpText("Iterations").defaultValue((Object)Argon2Parameters.DEFAULT_ITERATIONS).add();
        builder.property().name(PARALLELISM_KEY).type("int").helpText("Parallelism").defaultValue((Object)Argon2Parameters.DEFAULT_PARALLELISM).add();
        builder.property().name(CPU_CORES_KEY).type("int").helpText("Maximum parallel CPU cores to use for hashing").add();
        return builder.build();
    }

    public boolean isSupported(Config.Scope config) {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.FIPS);
    }

    public int order() {
        return 300;
    }
}

