/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.SASL;
import org.freedesktop.dbus.connections.config.SaslConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.transports.TransportConnection;
import org.freedesktop.dbus.exceptions.AuthenticationException;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.InvalidBusAddressException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.spi.message.IMessageReader;
import org.freedesktop.dbus.spi.message.IMessageWriter;
import org.freedesktop.dbus.spi.message.ISocketProvider;
import org.freedesktop.dbus.spi.message.InputStreamMessageReader;
import org.freedesktop.dbus.spi.message.OutputStreamMessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransport
implements Closeable {
    private static final AtomicLong TRANSPORT_ID_GENERATOR = new AtomicLong(0L);
    private final ServiceLoader<ISocketProvider> spiLoader = ServiceLoader.load(ISocketProvider.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BusAddress address;
    private TransportConnection transportConnection;
    private boolean fileDescriptorSupported;
    private final long transportId = TRANSPORT_ID_GENERATOR.incrementAndGet();
    private final TransportConfig config;

    protected AbstractTransport(BusAddress _address, TransportConfig _config) {
        this.address = Objects.requireNonNull(_address, "BusAddress required");
        this.config = Objects.requireNonNull(_config, "Config required");
        if (_address.isListeningSocket()) {
            this.config.getSaslConfig().setMode(SASL.SaslMode.SERVER);
        } else {
            this.config.getSaslConfig().setMode(SASL.SaslMode.CLIENT);
        }
        this.config.getSaslConfig().setGuid(this.address.getGuid());
        this.config.getSaslConfig().setFileDescriptorSupport(this.hasFileDescriptorSupport());
    }

    public void writeMessage(Message _msg) throws IOException {
        if (!this.fileDescriptorSupported && 104 == _msg.getType()) {
            throw new IllegalArgumentException("File descriptors are not supported!");
        }
        if (this.transportConnection.getWriter() == null || this.transportConnection.getWriter().isClosed()) {
            throw new IOException("OutputWriter already closed or null");
        }
        this.transportConnection.getWriter().writeMessage(_msg);
    }

    public Message readMessage() throws IOException, DBusException {
        if (this.transportConnection.getReader() != null && !this.transportConnection.getReader().isClosed()) {
            return this.transportConnection.getReader().readMessage();
        }
        throw new IOException("InputReader already closed or null");
    }

    public synchronized boolean isConnected() {
        return this.transportConnection != null && this.transportConnection.getWriter() != null && !this.transportConnection.getWriter().isClosed() && this.transportConnection.getReader() != null && !this.transportConnection.getReader().isClosed();
    }

    protected abstract boolean hasFileDescriptorSupport();

    @Deprecated(forRemoval=true, since="4.2.0 - 2022-07-18")
    protected abstract boolean isAbstractAllowed();

    protected abstract SocketChannel connectImpl() throws IOException;

    public final SocketChannel connect() throws IOException {
        if (this.getAddress().isListeningSocket()) {
            throw new InvalidBusAddressException("Cannot connect when using listening address (try use listen() instead)");
        }
        this.transportConnection = this.internalConnect();
        return this.transportConnection.getChannel();
    }

    public final TransportConnection listen() throws IOException {
        if (!this.getAddress().isListeningSocket()) {
            throw new InvalidBusAddressException("Cannot listen on client connection address (try use connect() instead)");
        }
        this.transportConnection = this.internalConnect();
        return this.transportConnection;
    }

    private TransportConnection internalConnect() throws IOException {
        if (this.config.getPreConnectCallback() != null) {
            this.config.getPreConnectCallback().accept(this);
        }
        SocketChannel channel = this.connectImpl();
        this.authenticate(channel);
        return this.createInputOutput(channel);
    }

    public void setPreConnectCallback(Consumer<AbstractTransport> _run) {
        this.config.setPreConnectCallback(_run);
    }

    private void authenticate(SocketChannel _sock) throws IOException {
        SASL sasl = new SASL(this.config.getSaslConfig());
        try {
            if (!sasl.auth(_sock, this)) {
                throw new AuthenticationException("Failed to authenticate");
            }
        }
        catch (IOException _ex) {
            _sock.close();
            throw _ex;
        }
        this.fileDescriptorSupported = sasl.isFileDescriptorSupported();
    }

    private TransportConnection createInputOutput(SocketChannel _socket) {
        IMessageReader reader = null;
        IMessageWriter writer = null;
        try {
            for (ISocketProvider provider : this.spiLoader) {
                this.logger.debug("Found ISocketProvider {}", (Object)provider);
                provider.setFileDescriptorSupport(this.hasFileDescriptorSupport() && this.fileDescriptorSupported);
                reader = provider.createReader(_socket);
                writer = provider.createWriter(_socket);
                if (reader == null || writer == null) continue;
                this.logger.debug("Using ISocketProvider {}", (Object)provider);
                break;
            }
        }
        catch (ServiceConfigurationError _ex) {
            this.logger.error("Could not initialize service provider", (Throwable)_ex);
        }
        catch (IOException _ex) {
            this.logger.error("Could not initialize alternative message reader/writer", (Throwable)_ex);
        }
        if (reader == null || writer == null) {
            this.logger.debug("No alternative ISocketProvider found, using built-in implementation");
            reader = new InputStreamMessageReader(_socket);
            writer = new OutputStreamMessageWriter(_socket);
            this.fileDescriptorSupported = false;
        }
        return new TransportConnection(_socket, writer, reader);
    }

    protected BusAddress getAddress() {
        return this.address;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected SaslConfig getSaslConfig() {
        return this.config.getSaslConfig();
    }

    @Deprecated(since="4.2.0 - 2022-07-22", forRemoval=true)
    protected int getSaslAuthMode() {
        return this.getSaslConfig().getAuthMode();
    }

    @Deprecated(since="4.2.0 - 2022-07-22", forRemoval=true)
    protected SASL.SaslMode getSaslMode() {
        return this.getSaslConfig().getMode();
    }

    @Deprecated(since="4.2.0 - 2022-07-22", forRemoval=true)
    protected void setSaslMode(SASL.SaslMode _saslMode) {
        this.getSaslConfig().setMode(_saslMode);
    }

    @Deprecated(since="4.2.0 - 2022-07-22", forRemoval=true)
    protected void setSaslAuthMode(int _mode) {
        this.getSaslConfig().setAuthMode(_mode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" [id=").append(this.transportId).append(", ");
        if (this.transportConnection != null) {
            sb.append("connectionId=").append(this.transportConnection.getId()).append(", ");
        }
        sb.append("address=").append(this.address).append("]");
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.transportConnection != null) {
            this.transportConnection.close();
            this.transportConnection = null;
        }
    }
}

