/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.DB2LegacyDialect;
import org.hibernate.community.dialect.DB2iLegacySqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.DB2SubstringFunction;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.DB2zIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.internal.DB2LockingSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.pagination.FetchLimitHandler;
import org.hibernate.dialect.pagination.LegacyDB2LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2iSequenceSupport;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.AlterTableUniqueIndexDelegate;
import org.hibernate.dialect.unique.SkipNullableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2iLegacyDialect
extends DB2LegacyDialect {
    static final DatabaseVersion DB2_LUW_VERSION9 = DatabaseVersion.make((Integer)9, (Integer)0);
    private static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make((Integer)7);

    public DB2iLegacyDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(DEFAULT_VERSION));
        this.registerKeywords(info);
    }

    public DB2iLegacyDialect() {
        this(DEFAULT_VERSION);
    }

    public DB2iLegacyDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected LockingSupport buildLockingSupport() {
        return DB2LockingSupport.forDB2i();
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        functionContributions.getFunctionRegistry().register("substring", (SqmFunctionDescriptor)new DB2SubstringFunction(false, functionContributions.getTypeConfiguration()));
        if (this.getVersion().isSameOrAfter(7, 2)) {
            CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
            functionFactory.listagg(null);
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        }
    }

    @Override
    public DatabaseVersion getDB2Version() {
        return DB2_LUW_VERSION9;
    }

    @Override
    protected UniqueDelegate createUniqueDelegate() {
        return this.getVersion().isSameOrAfter(7, 1) ? new AlterTableUniqueIndexDelegate((Dialect)this) : new SkipNullableUniqueDelegate((Dialect)this);
    }

    public String getCreateIndexString(boolean unique) {
        return unique ? "create unique where not null index" : "create index";
    }

    @Override
    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return "";
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isSameOrAfter(7, 3) ? DB2iSequenceSupport.INSTANCE : NoSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        if (this.getVersion().isSameOrAfter(7, 3)) {
            return "select distinct sequence_schema as seqschema, sequence_name as seqname, START, minimum_value as minvalue, maximum_value as maxvalue, increment from qsys2.syssequences where current_schema='*LIBL' and sequence_schema in (select schema_name from qsys2.library_list_info) or sequence_schema=current_schema";
        }
        return null;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.getVersion().isSameOrAfter(7, 3) ? FetchLimitHandler.INSTANCE : LegacyDB2LimitHandler.INSTANCE;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion().isSameOrAfter(7, 3) ? DB2IdentityColumnSupport.INSTANCE : DB2zIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(7, 1);
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return this.getVersion().isSameOrAfter(7, 1);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2iLegacySqlAstTranslator(sessionFactory, statement, DB2iLegacyDialect.this.getVersion());
            }
        };
    }
}

