/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.AbstractUpdateOrDeleteStatement;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DerbySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public DerbySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        if (DerbySqlAstTranslator.hasNonTrivialFromClause((FromClause)statement.getFromClause())) {
            this.appendSql("delete from ");
            Stack clauseStack = this.getClauseStack();
            try {
                clauseStack.push((Object)Clause.DELETE);
                super.renderDmlTargetTableExpression(statement.getTargetTable());
                this.append(" dml_target_");
            }
            finally {
                clauseStack.pop();
            }
            this.visitWhereClause(this.determineWhereClauseRestrictionWithJoinEmulation((AbstractUpdateOrDeleteStatement)statement, "dml_target_"));
            this.visitReturningColumns(statement.getReturningColumns());
        } else {
            super.visitDeleteStatementOnly(statement);
        }
    }

    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        if (DerbySqlAstTranslator.hasNonTrivialFromClause((FromClause)statement.getFromClause())) {
            this.appendSql("update ");
            Stack clauseStack = this.getClauseStack();
            try {
                clauseStack.push((Object)Clause.UPDATE);
                super.renderDmlTargetTableExpression(statement.getTargetTable());
                this.append(" dml_target_");
            }
            finally {
                clauseStack.pop();
            }
            this.renderSetClause(statement.getAssignments());
            this.visitWhereClause(this.determineWhereClauseRestrictionWithJoinEmulation((AbstractUpdateOrDeleteStatement)statement, "dml_target_"));
            this.visitReturningColumns(statement.getReturningColumns());
        } else {
            super.visitUpdateStatementOnly(statement);
        }
    }

    protected void visitSetAssignment(Assignment assignment) {
        UpdateStatement statement;
        Statement currentStatement = (Statement)this.getStatementStack().getCurrent();
        if (currentStatement instanceof UpdateStatement && DerbySqlAstTranslator.hasNonTrivialFromClause((FromClause)(statement = (UpdateStatement)currentStatement).getFromClause())) {
            this.visitSetAssignmentEmulateJoin(assignment, statement);
        } else {
            super.visitSetAssignment(assignment);
        }
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        }
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = ((CaseSearchedExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = ((CaseSimpleExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.assertRowsOnlyFetchClauseType(queryPart);
        if (this.supportsOffsetFetchClause()) {
            this.renderOffsetFetchClause(queryPart, true);
        } else if (!this.getClauseStack().isEmpty()) {
            throw new IllegalArgumentException("Can't render offset and fetch clause for subquery");
        }
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectExpression(Expression expression) {
        if (this.isInSubquery() && expression instanceof Literal) {
            this.renderCasted(expression);
        } else {
            this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
        }
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitInListPredicate(InListPredicate inListPredicate) {
        List listExpressions = inListPredicate.getListExpressions();
        if (listExpressions.isEmpty()) {
            this.appendSql("1=" + (inListPredicate.isNegated() ? "1" : "0"));
            return;
        }
        Expression testExpression = inListPredicate.getTestExpression();
        if (DerbySqlAstTranslator.isParameter((Expression)testExpression)) {
            this.renderCasted(testExpression);
            if (inListPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in (");
            this.renderCommaSeparated(listExpressions);
            this.appendSql(')');
        } else {
            super.visitInListPredicate(inListPredicate);
        }
    }

    protected boolean needsRowsToSkip() {
        return !this.supportsOffsetFetchClause();
    }

    protected boolean needsMaxRows() {
        return !this.supportsOffsetFetchClause();
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return true;
    }

    private boolean supportsOffsetFetchClause() {
        return true;
    }

    protected void visitArithmeticOperand(Expression expression) {
        this.render((SqlAstNode)expression, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
    }
}

