/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.JsonObjectFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class SingleStoreJsonObjectFunction
extends JsonObjectFunction {
    public SingleStoreJsonObjectFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, false);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql("json_build_object()");
        } else {
            int argumentsCount;
            JsonNullBehavior nullBehavior;
            SqlAstNode lastArgument = sqlAstArguments.get(sqlAstArguments.size() - 1);
            if (lastArgument instanceof JsonNullBehavior) {
                nullBehavior = (JsonNullBehavior)lastArgument;
                argumentsCount = sqlAstArguments.size() - 1;
            } else {
                nullBehavior = JsonNullBehavior.NULL;
                argumentsCount = sqlAstArguments.size();
            }
            if (nullBehavior == JsonNullBehavior.ABSENT) {
                sqlAppender.appendSql("(select concat('{', group_concat(concat(t.k, ':', t.v)), '}') from (select ");
                sqlAppender.appendSql("to_json(");
                sqlAstArguments.get(0).accept(walker);
                sqlAppender.appendSql(") k, ");
                sqlAppender.appendSql("to_json(");
                sqlAstArguments.get(1).accept(walker);
                sqlAppender.appendSql(") v");
                for (int i = 2; i < argumentsCount; i += 2) {
                    sqlAppender.appendSql(" union all select ");
                    sqlAppender.appendSql("to_json(");
                    sqlAstArguments.get(i).accept(walker);
                    sqlAppender.appendSql("),");
                    sqlAppender.appendSql("to_json(");
                    sqlAstArguments.get(i + 1).accept(walker);
                    sqlAppender.appendSql(")");
                }
                sqlAppender.appendSql(") t where t.v <> to_json(null))");
            } else {
                sqlAppender.appendSql("json_build_object");
                int separator = 40;
                for (int i = 0; i < argumentsCount; ++i) {
                    sqlAppender.appendSql((char)separator);
                    sqlAstArguments.get(i).accept(walker);
                    separator = 44;
                }
                sqlAppender.appendSql(')');
            }
        }
    }
}

