/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.hibernate.community.dialect.pagination.RowsLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class TimesTenLimitHandler
extends RowsLimitHandler {
    public static final TimesTenLimitHandler INSTANCE = new TimesTenLimitHandler();

    protected String insert(String rows, String sql) {
        return TimesTenLimitHandler.insertAfterSelect((String)rows, (String)sql);
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    @Override
    protected String limitClause(boolean hasFirstRow, int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        String firstParameter = parameterMarkerStrategy.createMarker(1, null);
        if (hasFirstRow) {
            return " rows " + firstParameter + " to " + parameterMarkerStrategy.createMarker(2, null);
        }
        return " rows " + firstParameter;
    }

    @Override
    protected String offsetOnlyClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return " rows " + parameterMarkerStrategy.createMarker(1, null) + " to 2147483647";
    }

    public int getParameterPositionStart(Limit limit) {
        return TimesTenLimitHandler.hasMaxRows((Limit)limit) ? (TimesTenLimitHandler.hasFirstRow((Limit)limit) ? 3 : 2) : (TimesTenLimitHandler.hasFirstRow((Limit)limit) ? 2 : 1);
    }
}

