/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

public class TJScalingFactor {
    private int num = 1;
    private int denom = 1;

    public TJScalingFactor(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Numerator and denominator must be >= 1");
        }
        this.num = n;
        this.denom = n2;
    }

    public int getNum() {
        return this.num;
    }

    public int getDenom() {
        return this.denom;
    }

    public int getScaled(int n) {
        return (n * this.num + this.denom - 1) / this.denom;
    }

    public boolean equals(TJScalingFactor tJScalingFactor) {
        return this.num == tJScalingFactor.num && this.denom == tJScalingFactor.denom;
    }

    public boolean isOne() {
        return this.num == 1 && this.denom == 1;
    }
}

