/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteRemotePeeringConnectionRequest
extends BmcRequest<Void> {
    private String remotePeeringConnectionId;
    private String ifMatch;

    public String getRemotePeeringConnectionId() {
        return this.remotePeeringConnectionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().remotePeeringConnectionId(this.remotePeeringConnectionId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",remotePeeringConnectionId=").append(String.valueOf(this.remotePeeringConnectionId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteRemotePeeringConnectionRequest)) {
            return false;
        }
        DeleteRemotePeeringConnectionRequest other = (DeleteRemotePeeringConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.remotePeeringConnectionId, other.remotePeeringConnectionId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.remotePeeringConnectionId == null ? 43 : this.remotePeeringConnectionId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteRemotePeeringConnectionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String remotePeeringConnectionId = null;
        private String ifMatch = null;

        public Builder remotePeeringConnectionId(String remotePeeringConnectionId) {
            this.remotePeeringConnectionId = remotePeeringConnectionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteRemotePeeringConnectionRequest o) {
            this.remotePeeringConnectionId(o.getRemotePeeringConnectionId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteRemotePeeringConnectionRequest build() {
            DeleteRemotePeeringConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteRemotePeeringConnectionRequest buildWithoutInvocationCallback() {
            DeleteRemotePeeringConnectionRequest request = new DeleteRemotePeeringConnectionRequest();
            request.remotePeeringConnectionId = this.remotePeeringConnectionId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

