/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;

abstract class SamplingThread
extends Thread {
    private static final boolean isSolaris = Platform.isSolaris();
    private static final boolean isLinux = Platform.isLinux();
    private static final boolean isUnix = isSolaris || isLinux;
    private static final int VIOLATION_THRESHOLD = 10;
    private static final boolean DEBUG = false;
    private volatile boolean terminated;
    private int count;
    private int samplingInterval;

    SamplingThread(int interval) {
        ThreadInfo.addProfilerServerThread(this);
        this.setPriority(10);
        this.setDaemon(true);
        this.samplingInterval = interval;
        if (isSolaris) {
            this.samplingInterval *= 1000000;
        } else if (isLinux) {
            this.samplingInterval *= 1000;
        }
    }

    @Override
    public void run() {
        int adjustedSamplingInterval = this.samplingInterval;
        int upperBound = this.samplingInterval * 5 / 4;
        int lowerBound = this.samplingInterval / 10;
        int violationCount = 10;
        long startTime = Timers.getCurrentTimeInCounts();
        while (!this.terminated) {
            if (!isUnix) {
                try {
                    Thread.sleep(this.samplingInterval);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                long time = Timers.getCurrentTimeInCounts();
                Timers.osSleep((int)adjustedSamplingInterval);
                time = Timers.getCurrentTimeInCounts() - time;
                if (time > (long)upperBound && adjustedSamplingInterval > lowerBound) {
                    if (violationCount > 0) {
                        --violationCount;
                    } else {
                        adjustedSamplingInterval = adjustedSamplingInterval * 95 / 100;
                        violationCount = 10;
                    }
                }
            }
            this.sample();
        }
        ThreadInfo.removeProfilerServerThread(this);
    }

    abstract void sample();

    void terminate() {
        this.terminated = true;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

