/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTaggingWorkRequestRequest
extends BmcRequest<Void> {
    private String workRequestId;

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public Builder toBuilder() {
        return new Builder().workRequestId(this.workRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTaggingWorkRequestRequest)) {
            return false;
        }
        GetTaggingWorkRequestRequest other = (GetTaggingWorkRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workRequestId, other.workRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTaggingWorkRequestRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workRequestId = null;

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTaggingWorkRequestRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTaggingWorkRequestRequest build() {
            GetTaggingWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTaggingWorkRequestRequest buildWithoutInvocationCallback() {
            GetTaggingWorkRequestRequest request = new GetTaggingWorkRequestRequest();
            request.workRequestId = this.workRequestId;
            return request;
        }
    }
}

