/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsps.parserapi;

import java.util.List;
import java.util.Vector;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.servlet.jsp.tagext.VariableInfo;
import org.netbeans.modules.web.jsps.parserapi.DumpVisitor;
import org.netbeans.modules.web.jsps.parserapi.ELNode;
import org.netbeans.modules.web.jsps.parserapi.Mark;
import org.xml.sax.Attributes;

public abstract class Node {
    public static final String JSP_URI = "http://java.sun.com/JSP/Page";
    public static final String DIRECTIVE_ACTION = "directive.";
    public static final String ROOT_ACTION = "root";
    public static final String JSP_ROOT_ACTION = "jsp:root";
    public static final String PAGE_DIRECTIVE_ACTION = "directive.page";
    public static final String JSP_PAGE_DIRECTIVE_ACTION = "jsp:directive.page";
    public static final String INCLUDE_DIRECTIVE_ACTION = "directive.include";
    public static final String JSP_INCLUDE_DIRECTIVE_ACTION = "jsp:directive.include";
    public static final String DECLARATION_ACTION = "declaration";
    public static final String JSP_DECLARATION_ACTION = "jsp:declaration";
    public static final String SCRIPTLET_ACTION = "scriptlet";
    public static final String JSP_SCRIPTLET_ACTION = "jsp:scriptlet";
    public static final String EXPRESSION_ACTION = "expression";
    public static final String JSP_EXPRESSION_ACTION = "jsp:expression";
    public static final String USE_BEAN_ACTION = "useBean";
    public static final String JSP_USE_BEAN_ACTION = "jsp:useBean";
    public static final String SET_PROPERTY_ACTION = "setProperty";
    public static final String JSP_SET_PROPERTY_ACTION = "jsp:setProperty";
    public static final String GET_PROPERTY_ACTION = "getProperty";
    public static final String JSP_GET_PROPERTY_ACTION = "jsp:getProperty";
    public static final String INCLUDE_ACTION = "include";
    public static final String JSP_INCLUDE_ACTION = "jsp:include";
    public static final String FORWARD_ACTION = "forward";
    public static final String JSP_FORWARD_ACTION = "jsp:forward";
    public static final String PARAM_ACTION = "param";
    public static final String JSP_PARAM_ACTION = "jsp:param";
    public static final String PARAMS_ACTION = "params";
    public static final String JSP_PARAMS_ACTION = "jsp:params";
    public static final String PLUGIN_ACTION = "plugin";
    public static final String JSP_PLUGIN_ACTION = "jsp:plugin";
    public static final String FALLBACK_ACTION = "fallback";
    public static final String JSP_FALLBACK_ACTION = "jsp:fallback";
    public static final String TEXT_ACTION = "text";
    public static final String JSP_TEXT_ACTION = "jsp:text";
    public static final String JSP_TEXT_ACTION_END = "</jsp:text>";
    public static final String ATTRIBUTE_ACTION = "attribute";
    public static final String JSP_ATTRIBUTE_ACTION = "jsp:attribute";
    public static final String BODY_ACTION = "body";
    public static final String JSP_BODY_ACTION = "jsp:body";
    public static final String ELEMENT_ACTION = "element";
    public static final String JSP_ELEMENT_ACTION = "jsp:element";
    public static final String OUTPUT_ACTION = "output";
    public static final String JSP_OUTPUT_ACTION = "jsp:output";
    public static final String TAGLIB_DIRECTIVE_ACTION = "taglib";
    public static final String JSP_TAGLIB_DIRECTIVE_ACTION = "jsp:taglib";
    public static final String INVOKE_ACTION = "invoke";
    public static final String JSP_INVOKE_ACTION = "jsp:invoke";
    public static final String DOBODY_ACTION = "doBody";
    public static final String JSP_DOBODY_ACTION = "jsp:doBody";
    public static final String TAG_DIRECTIVE_ACTION = "directive.tag";
    public static final String JSP_TAG_DIRECTIVE_ACTION = "jsp:directive.tag";
    public static final String ATTRIBUTE_DIRECTIVE_ACTION = "directive.attribute";
    public static final String JSP_ATTRIBUTE_DIRECTIVE_ACTION = "jsp:directive.attribute";
    public static final String VARIABLE_DIRECTIVE_ACTION = "directive.variable";
    public static final String JSP_VARIABLE_DIRECTIVE_ACTION = "jsp:directive.variable";
    public static final String URN_JSPTAGDIR = "urn:jsptagdir:";
    public static final String URN_JSPTLD = "urn:jsptld:";
    private static final VariableInfo[] ZERO_VARIABLE_INFO = new VariableInfo[0];
    protected Attributes attrs;
    protected Attributes taglibAttrs;
    protected Attributes nonTaglibXmlnsAttrs;
    protected Nodes body;
    protected String text;
    protected Mark startMark;
    protected int beginJavaLine;
    protected int endJavaLine;
    protected Node parent;
    protected Nodes namedAttributeNodes;
    protected String qName;
    protected String localName;
    private boolean isDummy;

    Node() {
        this.isDummy = true;
    }

    Node(Mark start, Node parent) {
        this.startMark = start;
        this.isDummy = start == null;
        this.addToParent(parent);
    }

    Node(String qName, String localName, Mark start, Node parent) {
        this.qName = qName;
        this.localName = localName;
        this.startMark = start;
        this.isDummy = start == null;
        this.addToParent(parent);
    }

    Node(String qName, String localName, Attributes attrs, Mark start, Node parent) {
        this.qName = qName;
        this.localName = localName;
        this.attrs = attrs;
        this.startMark = start;
        this.isDummy = start == null;
        this.addToParent(parent);
    }

    Node(String qName, String localName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
        this.qName = qName;
        this.localName = localName;
        this.attrs = attrs;
        this.nonTaglibXmlnsAttrs = nonTaglibXmlnsAttrs;
        this.taglibAttrs = taglibAttrs;
        this.startMark = start;
        this.isDummy = start == null;
        this.addToParent(parent);
    }

    Node(String qName, String localName, String text, Mark start, Node parent) {
        this.qName = qName;
        this.localName = localName;
        this.text = text;
        this.startMark = start;
        this.isDummy = start == null;
        this.addToParent(parent);
    }

    public String getQName() {
        return this.qName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public Attributes getTaglibAttributes() {
        return this.taglibAttrs;
    }

    public Attributes getNonTaglibXmlnsAttributes() {
        return this.nonTaglibXmlnsAttrs;
    }

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    public String getAttributeValue(String name) {
        return this.attrs == null ? null : this.attrs.getValue(name);
    }

    public String getTextAttribute(String name) {
        String attr = this.getAttributeValue(name);
        if (attr != null) {
            return attr;
        }
        NamedAttribute namedAttribute = this.getNamedAttributeNode(name);
        if (namedAttribute == null) {
            return null;
        }
        return namedAttribute.getText();
    }

    public NamedAttribute getNamedAttributeNode(String name) {
        NamedAttribute result = null;
        Nodes nodes = this.getNamedAttributeNodes();
        int numChildNodes = nodes.size();
        for (int i = 0; i < numChildNodes; ++i) {
            NamedAttribute na = (NamedAttribute)nodes.getNode(i);
            boolean found = false;
            int index = name.indexOf(58);
            found = index != -1 ? na.getName().equals(name) : na.getLocalName().equals(name);
            if (!found) continue;
            result = na;
            break;
        }
        return result;
    }

    public Nodes getNamedAttributeNodes() {
        if (this.namedAttributeNodes != null) {
            return this.namedAttributeNodes;
        }
        Nodes result = new Nodes();
        Nodes nodes = this.getBody();
        if (nodes != null) {
            Node n;
            int numChildNodes = nodes.size();
            for (int i = 0; i < numChildNodes && (n = nodes.getNode(i)) instanceof NamedAttribute; ++i) {
                result.add(n);
            }
        }
        this.namedAttributeNodes = result;
        return result;
    }

    public Nodes getBody() {
        return this.body;
    }

    public void setBody(Nodes body) {
        this.body = body;
    }

    public String getText() {
        return this.text;
    }

    public Mark getStart() {
        return this.startMark;
    }

    public Node getParent() {
        return this.parent;
    }

    public int getBeginJavaLine() {
        return this.beginJavaLine;
    }

    public void setBeginJavaLine(int begin) {
        this.beginJavaLine = begin;
    }

    public int getEndJavaLine() {
        return this.endJavaLine;
    }

    public void setEndJavaLine(int end) {
        this.endJavaLine = end;
    }

    public boolean isDummy() {
        return this.isDummy;
    }

    public Root getRoot() {
        Node n = this;
        while (!(n instanceof Root)) {
            n = n.getParent();
        }
        return (Root)n;
    }

    abstract void accept(Visitor var1) throws JspException;

    private void addToParent(Node parent) {
        if (parent != null) {
            this.parent = parent;
            Nodes parentBody = parent.getBody();
            if (parentBody == null) {
                parentBody = new Nodes();
                parent.setBody(parentBody);
            }
            parentBody.add(this);
        }
    }

    public static class NamedAttribute
    extends Node {
        private boolean trim = true;
        private ChildInfo childInfo;
        private String name;
        private String localName;
        private String prefix;

        public NamedAttribute(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_ATTRIBUTE_ACTION, attrs, null, null, start, parent);
        }

        public NamedAttribute(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.ATTRIBUTE_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
            if ("false".equals(this.getAttributeValue("trim"))) {
                this.trim = false;
            }
            this.childInfo = new ChildInfo();
            this.name = this.getAttributeValue("name");
            if (this.name != null) {
                this.localName = this.name;
                int index = this.name.indexOf(58);
                if (index != -1) {
                    this.prefix = this.name.substring(0, index);
                    this.localName = this.name.substring(index + 1);
                }
            }
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ChildInfo getChildInfo() {
            return this.childInfo;
        }

        public boolean isTrim() {
            return this.trim;
        }

        @Override
        public String getText() {
            String text = "";
            if (this.getBody() != null) {
                class AttributeVisitor
                extends Visitor {
                    String attrValue = null;

                    AttributeVisitor() {
                    }

                    @Override
                    public void visit(TemplateText txt) {
                        this.attrValue = new String(txt.getText());
                    }

                    public String getAttrValue() {
                        return this.attrValue;
                    }
                }
                AttributeVisitor attributeVisitor = new AttributeVisitor();
                try {
                    this.getBody().visit(attributeVisitor);
                }
                catch (JspException jspException) {
                    // empty catch block
                }
                text = attributeVisitor.getAttrValue();
            }
            return text;
        }
    }

    public static class Nodes {
        private List<Node> list;
        private Root root;

        public Nodes() {
            this.list = new Vector<Node>();
        }

        public Nodes(List<Node> l) {
            this.list = l;
        }

        public Nodes(Root root) {
            this.root = root;
            this.list = new Vector<Node>();
            this.list.add(root);
        }

        public void add(Node n) {
            this.list.add(n);
            this.root = null;
        }

        public void remove(Node n) {
            this.list.remove(n);
        }

        public void visit(Visitor v) throws JspException {
            for (Node n : this.list) {
                n.accept(v);
            }
        }

        public int size() {
            return this.list.size();
        }

        public Node getNode(int index) {
            Node n = null;
            try {
                n = this.list.get(index);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return n;
        }

        public Root getRoot() {
            return this.root;
        }

        public String toString() {
            return DumpVisitor.dump(this);
        }
    }

    public static class Root
    extends Node {
        private Root parentRoot;
        private boolean isXmlSyntax;
        private String pageEnc;
        private String jspConfigPageEnc;
        private boolean isDefaultPageEncoding;
        private boolean isEncodingSpecifiedInProlog;

        Root(Mark start, Node parent, boolean isXmlSyntax) {
            super(start, parent);
            Node r;
            this.isXmlSyntax = isXmlSyntax;
            this.qName = Node.JSP_ROOT_ACTION;
            this.localName = Node.ROOT_ACTION;
            for (r = parent; r != null && !(r instanceof Root); r = r.getParent()) {
            }
            this.parentRoot = (Root)r;
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public boolean isXmlSyntax() {
            return this.isXmlSyntax;
        }

        public void setJspConfigPageEncoding(String enc) {
            this.jspConfigPageEnc = enc;
        }

        public String getJspConfigPageEncoding() {
            return this.jspConfigPageEnc;
        }

        public void setPageEncoding(String enc) {
            this.pageEnc = enc;
        }

        public String getPageEncoding() {
            return this.pageEnc;
        }

        public void setIsDefaultPageEncoding(boolean isDefault) {
            this.isDefaultPageEncoding = isDefault;
        }

        public boolean isDefaultPageEncoding() {
            return this.isDefaultPageEncoding;
        }

        public void setIsEncodingSpecifiedInProlog(boolean isSpecified) {
            this.isEncodingSpecifiedInProlog = isSpecified;
        }

        public boolean isEncodingSpecifiedInProlog() {
            return this.isEncodingSpecifiedInProlog;
        }

        public Root getParentRoot() {
            return this.parentRoot;
        }
    }

    public static class Visitor {
        protected void doVisit(Node n) throws JspException {
        }

        protected void visitBody(Node n) throws JspException {
            if (n.getBody() != null) {
                n.getBody().visit(this);
            }
        }

        public void visit(Root n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(JspRoot n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(PageDirective n) throws JspException {
            this.doVisit(n);
        }

        public void visit(TagDirective n) throws JspException {
            this.doVisit(n);
        }

        public void visit(IncludeDirective n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(TaglibDirective n) throws JspException {
            this.doVisit(n);
        }

        public void visit(AttributeDirective n) throws JspException {
            this.doVisit(n);
        }

        public void visit(VariableDirective n) throws JspException {
            this.doVisit(n);
        }

        public void visit(Comment n) throws JspException {
            this.doVisit(n);
        }

        public void visit(Declaration n) throws JspException {
            this.doVisit(n);
        }

        public void visit(Expression n) throws JspException {
            this.doVisit(n);
        }

        public void visit(Scriptlet n) throws JspException {
            this.doVisit(n);
        }

        public void visit(ELExpression n) throws JspException {
            this.doVisit(n);
        }

        public void visit(IncludeAction n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(ForwardAction n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(GetProperty n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(SetProperty n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(ParamAction n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(ParamsAction n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(FallBackAction n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(UseBean n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(PlugIn n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(CustomTag n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(UninterpretedTag n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(JspElement n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(JspText n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(NamedAttribute n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(JspBody n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(InvokeAction n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(DoBodyAction n) throws JspException {
            this.doVisit(n);
            this.visitBody(n);
        }

        public void visit(TemplateText n) throws JspException {
            this.doVisit(n);
        }

        public void visit(JspOutput n) throws JspException {
            this.doVisit(n);
        }

        public void visit(AttributeGenerator n) throws JspException {
            this.doVisit(n);
        }
    }

    public static class JspAttribute {
        private String qName;
        private String uri;
        private String localName;
        private String value;
        private boolean expression;
        private boolean dynamic;
        private ELNode.Nodes el;
        private boolean namedAttribute;
        private NamedAttribute namedAttributeNode;

        JspAttribute(String qName, String uri, String localName, String value, boolean expr, ELNode.Nodes el, boolean dyn) {
            this.qName = qName;
            this.uri = uri;
            this.localName = localName;
            this.value = value;
            this.namedAttributeNode = null;
            this.expression = expr;
            this.el = el;
            this.dynamic = dyn;
            this.namedAttribute = false;
        }

        JspAttribute(NamedAttribute na, boolean dyn) {
            this.qName = na.getName();
            this.localName = na.getLocalName();
            this.value = null;
            this.namedAttributeNode = na;
            this.expression = false;
            this.el = null;
            this.dynamic = dyn;
            this.namedAttribute = true;
        }

        public String getName() {
            return this.qName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getURI() {
            return this.uri;
        }

        public String getValue() {
            return this.value;
        }

        public NamedAttribute getNamedAttributeNode() {
            return this.namedAttributeNode;
        }

        public boolean isExpression() {
            return this.expression;
        }

        public boolean isNamedAttribute() {
            return this.namedAttribute;
        }

        public boolean isELInterpreterInput() {
            return this.el != null;
        }

        public boolean isLiteral() {
            return !this.expression && this.el != null && !this.namedAttribute;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public ELNode.Nodes getEL() {
            return this.el;
        }
    }

    public static class TemplateText
    extends Node {
        public TemplateText(String text, Mark start, Node parent) {
            super(null, null, text, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void ltrim() {
            int index;
            for (index = 0; index < this.text.length() && this.text.charAt(index) <= ' '; ++index) {
            }
            this.text = this.text.substring(index);
        }

        public void rtrim() {
            int index;
            for (index = this.text.length(); index > 0 && this.text.charAt(index - 1) <= ' '; --index) {
            }
            this.text = this.text.substring(0, index);
        }

        public boolean isAllSpace() {
            boolean isAllSpace = true;
            for (int i = 0; i < this.text.length(); ++i) {
                if (Character.isWhitespace(this.text.charAt(i))) continue;
                isAllSpace = false;
                break;
            }
            return isAllSpace;
        }
    }

    public static class JspBody
    extends Node {
        private ChildInfo childInfo = new ChildInfo();

        public JspBody(Mark start, Node parent) {
            this(Node.JSP_BODY_ACTION, (Attributes)null, (Attributes)null, start, parent);
        }

        public JspBody(String qName, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.BODY_ACTION, null, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public ChildInfo getChildInfo() {
            return this.childInfo;
        }
    }

    public static class JspText
    extends Node {
        public JspText(String qName, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.TEXT_ACTION, null, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class AttributeGenerator
    extends Node {
        String name;
        CustomTag tag;

        public AttributeGenerator(Mark start, String name, CustomTag tag) {
            super(start, null);
            this.name = name;
            this.tag = tag;
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public String getName() {
            return this.name;
        }

        public CustomTag getTag() {
            return this.tag;
        }
    }

    public static class CustomTag
    extends Node {
        private String uri;
        private String prefix;
        private JspAttribute[] jspAttrs;
        private TagData tagData;
        private String tagHandlerPoolName;
        private TagInfo tagInfo;
        private TagFileInfo tagFileInfo;
        private Class tagHandlerClass;
        private VariableInfo[] varInfos;
        private int customNestingLevel;
        private ChildInfo childInfo;
        private boolean implementsIterationTag;
        private boolean implementsBodyTag;
        private boolean implementsTryCatchFinally;
        private boolean implementsSimpleTag;
        private boolean implementsDynamicAttributes;
        private Vector atBeginScriptingVars;
        private Vector atEndScriptingVars;
        private Vector nestedScriptingVars;
        private CustomTag customTagParent;
        private Integer numCount;

        public CustomTag(String qName, String prefix, String localName, String uri, Attributes attrs, Mark start, Node parent, TagInfo tagInfo, Class tagHandlerClass) {
            this(qName, prefix, localName, uri, attrs, null, null, start, parent, tagInfo, tagHandlerClass);
        }

        public CustomTag(String qName, String prefix, String localName, String uri, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent, TagInfo tagInfo, Class tagHandlerClass) {
            super(qName, localName, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
            this.uri = uri;
            this.prefix = prefix;
            this.tagInfo = tagInfo;
            this.tagHandlerClass = tagHandlerClass;
            this.customNestingLevel = this.makeCustomNestingLevel();
            this.childInfo = new ChildInfo();
            this.implementsIterationTag = IterationTag.class.isAssignableFrom(tagHandlerClass);
            this.implementsBodyTag = BodyTag.class.isAssignableFrom(tagHandlerClass);
            this.implementsTryCatchFinally = TryCatchFinally.class.isAssignableFrom(tagHandlerClass);
            this.implementsSimpleTag = SimpleTag.class.isAssignableFrom(tagHandlerClass);
            this.implementsDynamicAttributes = DynamicAttributes.class.isAssignableFrom(tagHandlerClass);
        }

        public CustomTag(String qName, String prefix, String localName, String uri, Attributes attrs, Mark start, Node parent, TagFileInfo tagFileInfo) {
            this(qName, prefix, localName, uri, attrs, null, null, start, parent, tagFileInfo);
        }

        public CustomTag(String qName, String prefix, String localName, String uri, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent, TagFileInfo tagFileInfo) {
            super(qName, localName, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
            this.uri = uri;
            this.prefix = prefix;
            this.tagFileInfo = tagFileInfo;
            this.tagInfo = tagFileInfo.getTagInfo();
            this.customNestingLevel = this.makeCustomNestingLevel();
            this.childInfo = new ChildInfo();
            this.implementsIterationTag = false;
            this.implementsBodyTag = false;
            this.implementsTryCatchFinally = false;
            this.implementsSimpleTag = true;
            this.implementsDynamicAttributes = this.tagInfo.hasDynamicAttributes();
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public String getURI() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setJspAttributes(JspAttribute[] jspAttrs) {
            this.jspAttrs = jspAttrs;
        }

        public JspAttribute[] getJspAttributes() {
            return this.jspAttrs;
        }

        public ChildInfo getChildInfo() {
            return this.childInfo;
        }

        public void setTagData(TagData tagData) {
            this.tagData = tagData;
            this.varInfos = this.tagInfo.getVariableInfo(tagData);
            if (this.varInfos == null) {
                this.varInfos = ZERO_VARIABLE_INFO;
            }
        }

        public TagData getTagData() {
            return this.tagData;
        }

        public void setTagHandlerPoolName(String s) {
            this.tagHandlerPoolName = s;
        }

        public String getTagHandlerPoolName() {
            return this.tagHandlerPoolName;
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public TagFileInfo getTagFileInfo() {
            return this.tagFileInfo;
        }

        public boolean isTagFile() {
            return this.tagFileInfo != null;
        }

        public Class getTagHandlerClass() {
            return this.tagHandlerClass;
        }

        public void setTagHandlerClass(Class hc) {
            this.tagHandlerClass = hc;
        }

        public boolean implementsIterationTag() {
            return this.implementsIterationTag;
        }

        public boolean implementsBodyTag() {
            return this.implementsBodyTag;
        }

        public boolean implementsTryCatchFinally() {
            return this.implementsTryCatchFinally;
        }

        public boolean implementsSimpleTag() {
            return this.implementsSimpleTag;
        }

        public boolean implementsDynamicAttributes() {
            return this.implementsDynamicAttributes;
        }

        public TagVariableInfo[] getTagVariableInfos() {
            return this.tagInfo.getTagVariableInfos();
        }

        public VariableInfo[] getVariableInfos() {
            return this.varInfos;
        }

        public void setCustomTagParent(CustomTag n) {
            this.customTagParent = n;
        }

        public CustomTag getCustomTagParent() {
            return this.customTagParent;
        }

        public void setNumCount(Integer count) {
            this.numCount = count;
        }

        public Integer getNumCount() {
            return this.numCount;
        }

        public void setScriptingVars(Vector vec, int scope) {
            switch (scope) {
                case 1: {
                    this.atBeginScriptingVars = vec;
                    break;
                }
                case 2: {
                    this.atEndScriptingVars = vec;
                    break;
                }
                case 0: {
                    this.nestedScriptingVars = vec;
                }
            }
        }

        public Vector getScriptingVars(int scope) {
            Vector vec = null;
            switch (scope) {
                case 1: {
                    vec = this.atBeginScriptingVars;
                    break;
                }
                case 2: {
                    vec = this.atEndScriptingVars;
                    break;
                }
                case 0: {
                    vec = this.nestedScriptingVars;
                }
            }
            return vec;
        }

        public int getCustomNestingLevel() {
            return this.customNestingLevel;
        }

        public boolean checkIfAttributeIsJspFragment(String name) {
            boolean result = false;
            TagAttributeInfo[] attributes = this.tagInfo.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals(name) || !attributes[i].isFragment()) continue;
                result = true;
                break;
            }
            return result;
        }

        private int makeCustomNestingLevel() {
            int n = 0;
            Node p = this.parent;
            while (p != null) {
                if (p instanceof CustomTag && this.qName.equals(((CustomTag)p).qName)) {
                    ++n;
                }
                p = p.parent;
            }
            return n;
        }

        public boolean hasEmptyBody() {
            boolean hasEmptyBody = true;
            Nodes nodes = this.getBody();
            if (nodes != null) {
                int numChildNodes = nodes.size();
                for (int i = 0; i < numChildNodes; ++i) {
                    Node n = nodes.getNode(i);
                    if (n instanceof NamedAttribute) continue;
                    if (n instanceof JspBody) {
                        hasEmptyBody = n.getBody() == null;
                        break;
                    }
                    hasEmptyBody = false;
                    break;
                }
            }
            return hasEmptyBody;
        }
    }

    public static class ChildInfo {
        private boolean scriptless;
        private boolean hasUseBean;
        private boolean hasIncludeAction;
        private boolean hasParamAction;
        private boolean hasSetProperty;
        private boolean hasScriptingVars;

        public void setScriptless(boolean s) {
            this.scriptless = s;
        }

        public boolean isScriptless() {
            return this.scriptless;
        }

        public void setHasUseBean(boolean u) {
            this.hasUseBean = u;
        }

        public boolean hasUseBean() {
            return this.hasUseBean;
        }

        public void setHasIncludeAction(boolean i) {
            this.hasIncludeAction = i;
        }

        public boolean hasIncludeAction() {
            return this.hasIncludeAction;
        }

        public void setHasParamAction(boolean i) {
            this.hasParamAction = i;
        }

        public boolean hasParamAction() {
            return this.hasParamAction;
        }

        public void setHasSetProperty(boolean s) {
            this.hasSetProperty = s;
        }

        public boolean hasSetProperty() {
            return this.hasSetProperty;
        }

        public void setHasScriptingVars(boolean s) {
            this.hasScriptingVars = s;
        }

        public boolean hasScriptingVars() {
            return this.hasScriptingVars;
        }
    }

    public static class JspOutput
    extends Node {
        public JspOutput(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.OUTPUT_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class JspElement
    extends Node {
        private JspAttribute[] jspAttrs;
        private JspAttribute nameAttr;

        public JspElement(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_ELEMENT_ACTION, attrs, null, null, start, parent);
        }

        public JspElement(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.ELEMENT_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setJspAttributes(JspAttribute[] jspAttrs) {
            this.jspAttrs = jspAttrs;
        }

        public JspAttribute[] getJspAttributes() {
            return this.jspAttrs;
        }

        public void setNameAttribute(JspAttribute nameAttr) {
            this.nameAttr = nameAttr;
        }

        public JspAttribute getNameAttribute() {
            return this.nameAttr;
        }
    }

    public static class UninterpretedTag
    extends Node {
        private JspAttribute[] jspAttrs;

        public UninterpretedTag(String qName, String localName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, localName, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setJspAttributes(JspAttribute[] jspAttrs) {
            this.jspAttrs = jspAttrs;
        }

        public JspAttribute[] getJspAttributes() {
            return this.jspAttrs;
        }
    }

    public static class PlugIn
    extends Node {
        private JspAttribute width;
        private JspAttribute height;

        public PlugIn(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_PLUGIN_ACTION, attrs, null, null, start, parent);
        }

        public PlugIn(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.PLUGIN_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setHeight(JspAttribute height) {
            this.height = height;
        }

        public void setWidth(JspAttribute width) {
            this.width = width;
        }

        public JspAttribute getHeight() {
            return this.height;
        }

        public JspAttribute getWidth() {
            return this.width;
        }
    }

    public static class UseBean
    extends Node {
        JspAttribute beanName;

        public UseBean(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_USE_BEAN_ACTION, attrs, null, null, start, parent);
        }

        public UseBean(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.USE_BEAN_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setBeanName(JspAttribute beanName) {
            this.beanName = beanName;
        }

        public JspAttribute getBeanName() {
            return this.beanName;
        }
    }

    public static class SetProperty
    extends Node {
        private JspAttribute value;

        public SetProperty(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_SET_PROPERTY_ACTION, attrs, null, null, start, parent);
        }

        public SetProperty(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.SET_PROPERTY_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setValue(JspAttribute value) {
            this.value = value;
        }

        public JspAttribute getValue() {
            return this.value;
        }
    }

    public static class GetProperty
    extends Node {
        public GetProperty(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_GET_PROPERTY_ACTION, attrs, null, null, start, parent);
        }

        public GetProperty(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.GET_PROPERTY_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class ForwardAction
    extends Node {
        private JspAttribute page;

        public ForwardAction(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_FORWARD_ACTION, attrs, null, null, start, parent);
        }

        public ForwardAction(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.FORWARD_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setPage(JspAttribute page) {
            this.page = page;
        }

        public JspAttribute getPage() {
            return this.page;
        }
    }

    public static class IncludeAction
    extends Node {
        private JspAttribute page;

        public IncludeAction(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_INCLUDE_ACTION, attrs, null, null, start, parent);
        }

        public IncludeAction(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.INCLUDE_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setPage(JspAttribute page) {
            this.page = page;
        }

        public JspAttribute getPage() {
            return this.page;
        }
    }

    public static class FallBackAction
    extends Node {
        public FallBackAction(Mark start, Node parent) {
            this(Node.JSP_FALLBACK_ACTION, (Attributes)null, (Attributes)null, start, parent);
        }

        public FallBackAction(String qName, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.FALLBACK_ACTION, null, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class ParamsAction
    extends Node {
        public ParamsAction(Mark start, Node parent) {
            this(Node.JSP_PARAMS_ACTION, (Attributes)null, (Attributes)null, start, parent);
        }

        public ParamsAction(String qName, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.PARAMS_ACTION, null, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class ParamAction
    extends Node {
        JspAttribute value;

        public ParamAction(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_PARAM_ACTION, attrs, null, null, start, parent);
        }

        public ParamAction(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.PARAM_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setValue(JspAttribute value) {
            this.value = value;
        }

        public JspAttribute getValue() {
            return this.value;
        }
    }

    public static class ELExpression
    extends Node {
        private ELNode.Nodes el;

        public ELExpression(String text, Mark start, Node parent) {
            super(null, null, text, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void setEL(ELNode.Nodes el) {
            this.el = el;
        }

        public ELNode.Nodes getEL() {
            return this.el;
        }
    }

    public static class Scriptlet
    extends ScriptingElement {
        public Scriptlet(String text, Mark start, Node parent) {
            super(Node.JSP_SCRIPTLET_ACTION, Node.SCRIPTLET_ACTION, text, start, parent);
        }

        public Scriptlet(String qName, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.SCRIPTLET_ACTION, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class Expression
    extends ScriptingElement {
        public Expression(String text, Mark start, Node parent) {
            super(Node.JSP_EXPRESSION_ACTION, Node.EXPRESSION_ACTION, text, start, parent);
        }

        public Expression(String qName, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.EXPRESSION_ACTION, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class Declaration
    extends ScriptingElement {
        public Declaration(String text, Mark start, Node parent) {
            super(Node.JSP_DECLARATION_ACTION, Node.DECLARATION_ACTION, text, start, parent);
        }

        public Declaration(String qName, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.DECLARATION_ACTION, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static abstract class ScriptingElement
    extends Node {
        public ScriptingElement(String qName, String localName, String text, Mark start, Node parent) {
            super(qName, localName, text, start, parent);
        }

        public ScriptingElement(String qName, String localName, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, localName, null, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public String getText() {
            String ret = this.text;
            if (ret == null && this.body != null) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.body.size(); ++i) {
                    buf.append(this.body.getNode(i).getText());
                }
                ret = buf.toString();
            }
            return ret;
        }
    }

    public static class Comment
    extends Node {
        public Comment(String text, Mark start, Node parent) {
            super(null, null, text, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class DoBodyAction
    extends Node {
        public DoBodyAction(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_DOBODY_ACTION, attrs, null, null, start, parent);
        }

        public DoBodyAction(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.DOBODY_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class InvokeAction
    extends Node {
        public InvokeAction(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_INVOKE_ACTION, attrs, null, null, start, parent);
        }

        public InvokeAction(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.INVOKE_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class VariableDirective
    extends Node {
        public VariableDirective(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_VARIABLE_DIRECTIVE_ACTION, attrs, null, null, start, parent);
        }

        public VariableDirective(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.VARIABLE_DIRECTIVE_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class AttributeDirective
    extends Node {
        public AttributeDirective(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_ATTRIBUTE_DIRECTIVE_ACTION, attrs, null, null, start, parent);
        }

        public AttributeDirective(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.ATTRIBUTE_DIRECTIVE_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class TagDirective
    extends Node {
        private Vector<String> imports = new Vector();

        public TagDirective(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_TAG_DIRECTIVE_ACTION, attrs, null, null, start, parent);
        }

        public TagDirective(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.TAG_DIRECTIVE_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void addImport(String value) {
            int index;
            int start = 0;
            while ((index = value.indexOf(44, start)) != -1) {
                this.imports.add(value.substring(start, index).trim());
                start = index + 1;
            }
            if (start == 0) {
                this.imports.add(value.trim());
            } else {
                this.imports.add(value.substring(start).trim());
            }
        }

        public List<String> getImports() {
            return this.imports;
        }
    }

    public static class TaglibDirective
    extends Node {
        public TaglibDirective(Attributes attrs, Mark start, Node parent) {
            super(Node.JSP_TAGLIB_DIRECTIVE_ACTION, Node.TAGLIB_DIRECTIVE_ACTION, attrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class IncludeDirective
    extends Node {
        public IncludeDirective(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_INCLUDE_DIRECTIVE_ACTION, attrs, null, null, start, parent);
        }

        public IncludeDirective(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.INCLUDE_DIRECTIVE_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }

    public static class PageDirective
    extends Node {
        private Vector<String> imports = new Vector();

        public PageDirective(Attributes attrs, Mark start, Node parent) {
            this(Node.JSP_PAGE_DIRECTIVE_ACTION, attrs, null, null, start, parent);
        }

        public PageDirective(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.PAGE_DIRECTIVE_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }

        public void addImport(String value) {
            int index;
            int start = 0;
            while ((index = value.indexOf(44, start)) != -1) {
                this.imports.add(value.substring(start, index).trim());
                start = index + 1;
            }
            if (start == 0) {
                this.imports.add(value.trim());
            } else {
                this.imports.add(value.substring(start).trim());
            }
        }

        public List<String> getImports() {
            return this.imports;
        }
    }

    public static class JspRoot
    extends Node {
        public JspRoot(String qName, Attributes attrs, Attributes nonTaglibXmlnsAttrs, Attributes taglibAttrs, Mark start, Node parent) {
            super(qName, Node.ROOT_ACTION, attrs, nonTaglibXmlnsAttrs, taglibAttrs, start, parent);
        }

        @Override
        public void accept(Visitor v) throws JspException {
            v.visit(this);
        }
    }
}

