/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class Subprojects
implements SubprojectProvider {
    private final FreeformProject project;

    public Subprojects(FreeformProject project) {
        this.project = project;
    }

    public Set<? extends Project> getSubprojects() {
        return new LazySubprojectsSet();
    }

    private Set<Project> createSubprojects(Set<Project> subprojects) {
        Element config = this.project.getPrimaryConfigurationData();
        Element subprjsEl = XMLUtil.findElement((Element)config, (String)"subprojects", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (subprjsEl != null) {
            for (Element prjEl : XMLUtil.findSubElements((Element)subprjsEl)) {
                FileObject subprjDir;
                assert (prjEl.getLocalName().equals("project")) : "Bad element " + prjEl + " in <subprojects> for " + this.project;
                String rawtext = XMLUtil.findText((Node)prjEl);
                assert (rawtext != null) : "Need text content for <project> in " + this.project;
                String evaltext = this.project.evaluator().evaluate(rawtext);
                if (evaltext == null || (subprjDir = this.project.helper().resolveFileObject(evaltext)) == null) continue;
                try {
                    Project p = ProjectManager.getDefault().findProject(subprjDir);
                    if (p == null) continue;
                    if (subprojects == null) {
                        return Collections.emptySet();
                    }
                    subprojects.add(p);
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                }
            }
        }
        return subprojects;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    private final class LazySubprojectsSet
    implements Set<Project> {
        private Set<Project> delegateTo = null;

        private LazySubprojectsSet() {
        }

        private synchronized Set<Project> getDelegateTo() {
            if (this.delegateTo == null) {
                this.delegateTo = Subprojects.this.createSubprojects(new HashSet());
            }
            return this.delegateTo;
        }

        @Override
        public boolean contains(Object o) {
            return this.getDelegateTo().contains(o);
        }

        @Override
        public boolean add(Project p) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Project> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.getDelegateTo().containsAll(c);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getDelegateTo().toArray(a);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.getDelegateTo().size();
        }

        @Override
        public synchronized boolean isEmpty() {
            if (this.delegateTo == null) {
                return Subprojects.this.createSubprojects(null) == null;
            }
            return this.delegateTo.isEmpty();
        }

        @Override
        public Iterator<Project> iterator() {
            return this.getDelegateTo().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.getDelegateTo().toArray();
        }

        @Override
        public int hashCode() {
            return this.getDelegateTo().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegateTo().equals(obj);
        }

        public String toString() {
            return this.getDelegateTo().toString();
        }
    }
}

