/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.netbeans.modules.groovy.support.api.Bundle;
import org.netbeans.modules.groovy.support.options.SupportOptionsPanelController;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.NbPreferences;

public final class GroovySettings
extends AdvancedOption {
    public static final String GROOVY_OPTIONS_CATEGORY = "Advanced/org-netbeans-modules-groovy-support-api-GroovySettings";
    public static final String GROOVY_DOC_PROPERTY = "groovy.doc";
    private static final String GROOVY_DOC = "groovyDoc";
    private static final String ACCESS_MODIFIERS = "honourAccessModifiers";
    private static final boolean DEFAULT_ACCESS_MODIFIERS = false;
    private static GroovySettings instance;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);

    private GroovySettings() {
    }

    public static synchronized GroovySettings getInstance() {
        if (instance == null) {
            instance = new GroovySettings();
        }
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroovyDoc() {
        GroovySettings groovySettings = this;
        synchronized (groovySettings) {
            return this.getPreferences().get(GROOVY_DOC, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroovyDoc(String groovyDoc) {
        String oldValue;
        assert (groovyDoc != null);
        GroovySettings groovySettings = this;
        synchronized (groovySettings) {
            oldValue = this.getGroovyDoc();
            this.getPreferences().put(GROOVY_DOC, groovyDoc);
        }
        this.propertyChangeSupport.firePropertyChange(GROOVY_DOC_PROPERTY, oldValue, groovyDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHonourAccessModifiers(boolean mods) {
        boolean old;
        GroovySettings groovySettings = this;
        synchronized (groovySettings) {
            old = this.isHonourAccessModifiers();
            this.getPreferences().putBoolean(ACCESS_MODIFIERS, mods);
        }
        this.propertyChangeSupport.firePropertyChange(ACCESS_MODIFIERS, old, mods);
    }

    public boolean isHonourAccessModifiers() {
        return this.getPreferences().getBoolean(ACCESS_MODIFIERS, false);
    }

    public String getDisplayName() {
        return Bundle.AdvancedOption_DisplayName_Support();
    }

    public String getTooltip() {
        return Bundle.AdvancedOption_Tooltip_Support();
    }

    public OptionsPanelController create() {
        return new SupportOptionsPanelController();
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(GroovySettings.class);
    }
}

