/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class EventBufferDumpedCommand
extends Command {
    private int bufSize;
    private String eventBufferFileName;
    private byte[] buffer;
    private int startPos;

    public EventBufferDumpedCommand(int bufSize, byte[] buf, int start) {
        super(26);
        this.bufSize = bufSize;
        this.buffer = buf;
        this.startPos = start;
        this.eventBufferFileName = "";
    }

    public EventBufferDumpedCommand(int bufSize, String bufferName) {
        super(26);
        this.bufSize = bufSize;
        this.buffer = null;
        this.startPos = -1;
        this.eventBufferFileName = bufferName;
    }

    EventBufferDumpedCommand() {
        super(26);
    }

    public int getBufSize() {
        return this.bufSize;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public String toString() {
        return super.toString() + ", bufSize: " + this.bufSize + (this.eventBufferFileName.length() > 0 ? ", eventBufferFileName:" + this.eventBufferFileName : "");
    }

    public String getEventBufferFileName() {
        return this.eventBufferFileName;
    }

    @Override
    void readObject(ObjectInputStream in) throws IOException {
        this.bufSize = in.readInt();
        boolean hasBuffer = in.readBoolean();
        if (hasBuffer) {
            int compressedSize = in.readInt();
            byte[] compressedBuf = new byte[compressedSize];
            Inflater decompressor = new Inflater();
            this.buffer = new byte[this.bufSize];
            in.readFully(compressedBuf);
            decompressor.setInput(compressedBuf);
            try {
                int originalSize = decompressor.inflate(this.buffer);
                assert (originalSize == this.bufSize);
            }
            catch (DataFormatException ex) {
                throw new IOException(ex.getMessage());
            }
            finally {
                decompressor.end();
            }
            this.eventBufferFileName = "";
        } else {
            this.eventBufferFileName = in.readUTF();
        }
    }

    @Override
    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.bufSize);
        out.writeBoolean(this.buffer != null);
        if (this.buffer != null) {
            Deflater compressor = new Deflater();
            byte[] compressedBytes = new byte[this.bufSize + 32];
            compressor.setInput(this.buffer, this.startPos, this.bufSize);
            compressor.finish();
            int compressedSize = compressor.deflate(compressedBytes);
            out.writeInt(compressedSize);
            out.write(compressedBytes, 0, compressedSize);
        } else {
            out.writeUTF(this.eventBufferFileName);
        }
    }
}

